/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.parser.common.grammar.GrammarRule;

public class ParseTreeNode {
    private final GrammarRule rule;
    private final String tag;
    private final int position;
    private final ParseTreeNode parent;
    private final List<ParseTreeNode> children;
    private int endPosition;

    public ParseTreeNode(GrammarRule rule, String tag, int position, int endPosition, ParseTreeNode parent, List<ParseTreeNode> children) {
        this.rule = rule;
        this.tag = tag;
        this.position = position;
        this.endPosition = endPosition;
        this.parent = parent;
        this.children = children;
    }

    public GrammarRule getRule() {
        return this.rule;
    }

    public String getTag() {
        return this.tag;
    }

    public int getPosition() {
        return this.position;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    public ParseTreeNode getParent() {
        return this.parent;
    }

    public List<ParseTreeNode> getChildren() {
        return this.children;
    }

    public String collectString() {
        return this.collectString(null);
    }

    public String collectString(String text) {
        StringBuilder sb = new StringBuilder();
        this.collectStringImpl(sb, text, "");
        return sb.toString();
    }

    @NotNull
    public Stream<ParseTreeNode> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Itr(this), 1025), false);
    }

    private void collectStringImpl(StringBuilder sb, String text, String indent) {
        sb.append(indent);
        if (this.rule == null && this.children.size() == 0) {
            if (text != null && this.position >= 0 && this.endPosition >= this.position && this.endPosition <= text.length()) {
                sb.append("'").append(text.substring(this.position, this.endPosition)).append("'");
            } else {
                sb.append("<TERM> ");
            }
        } else {
            sb.append(this.rule == null ? "<NULL>" : this.rule.getName());
        }
        if (text != null || this.rule == null && this.children.size() == 0) {
            sb.append(" (").append(this.position).append("-").append(this.endPosition).append(")");
        }
        sb.append("\n");
        for (ParseTreeNode child : this.children) {
            child.collectStringImpl(sb, text, String.valueOf(indent) + "  ");
        }
    }

    public String getContent(String text) {
        return text.substring(this.getPosition(), this.getEndPosition());
    }

    private static class Itr
    implements Iterator<ParseTreeNode> {
        private final Queue<ParseTreeNode> queue = new ArrayDeque<ParseTreeNode>();

        public Itr(@NotNull ParseTreeNode root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public ParseTreeNode next() {
            ParseTreeNode node = this.queue.remove();
            this.queue.addAll(node.children);
            return node;
        }
    }
}

