/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.internal.ui.palette.editparts;

import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.ButtonModel;
import org.eclipse.draw2dl.ChangeEvent;
import org.eclipse.draw2dl.ChangeListener;
import org.eclipse.draw2dl.FigureUtilities;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.ImageFigure;
import org.eclipse.draw2dl.Label;
import org.eclipse.draw2dl.MarginBorder;
import org.eclipse.draw2dl.Toggle;
import org.eclipse.gef3.internal.InternalImages;
import org.eclipse.gef3.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef3.ui.palette.PaletteMessages;
import org.eclipse.swt.graphics.Color;

public class PinFigure
extends Toggle {
    private static final Color PIN_HOTSPOT_COLOR = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_LIST_BACKGROUND, (Color)PaletteColorUtil.WIDGET_NORMAL_SHADOW, (double)0.6);
    private static final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0);

    public PinFigure() {
        super((IFigure)new ImageFigure(InternalImages.get("icons/unpinned.gif")));
        this.setRolloverEnabled(true);
        this.setRequestFocusEnabled(false);
        Label tooltip = new Label(PaletteMessages.TOOLTIP_PIN_FIGURE);
        tooltip.setBorder(TOOLTIP_BORDER);
        this.setToolTip((IFigure)tooltip);
        this.setOpaque(false);
        this.addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent e) {
                if (e.getPropertyName().equals("selected")) {
                    if (PinFigure.this.isSelected()) {
                        ((ImageFigure)PinFigure.this.getChildren().get(0)).setImage(InternalImages.get("icons/pinned.gif"));
                        ((Label)PinFigure.this.getToolTip()).setText(PaletteMessages.TOOLTIP_UNPIN_FIGURE);
                    } else {
                        ((ImageFigure)PinFigure.this.getChildren().get(0)).setImage(InternalImages.get("icons/unpinned.gif"));
                        ((Label)PinFigure.this.getToolTip()).setText(PaletteMessages.TOOLTIP_PIN_FIGURE);
                    }
                }
            }
        });
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        ButtonModel model = this.getModel();
        if (this.isRolloverEnabled() && model.isMouseOver()) {
            graphics.setBackgroundColor(PIN_HOTSPOT_COLOR);
            graphics.fillRoundRectangle(this.getClientArea().getCopy().shrink(1, 1), 3, 3);
        }
    }
}

