/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.parts;

import org.eclipse.draw2dl.FigureCanvas;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Viewport;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScrollingGraphicalViewer
extends GraphicalViewerImpl {
    @Override
    public final Control createControl(Composite parent) {
        this.setControl((Control)new FigureCanvas(parent, this.getLightweightSystem()));
        this.hookRootFigure();
        return this.getControl();
    }

    protected FigureCanvas getFigureCanvas() {
        return (FigureCanvas)this.getControl();
    }

    @Override
    public void reveal(EditPart part) {
        super.reveal(part);
        Viewport port = this.getFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getCopy();
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        exposeRegion.expand(5, 5);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    @Override
    protected void hookRootFigure() {
        if (this.getFigureCanvas() == null) {
            return;
        }
        if (this.rootFigure instanceof Viewport) {
            this.getFigureCanvas().setViewport((Viewport)this.rootFigure);
        } else {
            this.getFigureCanvas().setContents(this.rootFigure);
        }
    }
}

