/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLBlockCompletionsCollection;
import org.jkiss.utils.CommonUtils;

public class SQLBlockCompletionInfo {
    private final SQLBlockCompletionsCollection owner;
    private final int headTokenId;
    private final String[] completionParts;
    private final int tailTokenId;
    private final Integer tailEndTokenId;
    private final Integer headCancelTokenId;

    public SQLBlockCompletionInfo(@NotNull SQLBlockCompletionsCollection owner, int headTokenId, @Nullable String[] completionParts, int tailTokenId, @Nullable Integer tailEndTokenId, @Nullable Integer prevCancelTokenId) {
        this.owner = owner;
        this.headTokenId = headTokenId;
        this.completionParts = completionParts;
        this.tailTokenId = tailTokenId;
        this.tailEndTokenId = tailEndTokenId;
        this.headCancelTokenId = prevCancelTokenId;
    }

    public int getHeadTokenId() {
        return this.headTokenId;
    }

    @Nullable
    public String[] getCompletionParts() {
        return this.completionParts;
    }

    public int getTailTokenId() {
        return this.tailTokenId;
    }

    @Nullable
    public Integer getTailEndTokenId() {
        return this.tailEndTokenId;
    }

    @Nullable
    public Integer getHeadCancelTokenId() {
        return this.headCancelTokenId;
    }

    @NotNull
    private String getTokenString(Integer tokenId) {
        return tokenId == null ? "<UNBOUND>" : (String)CommonUtils.notNull((Object)this.owner.findTokenString(tokenId), (Object)("<UNKNOWN TOKEN ID #" + tokenId + ">"));
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.headCancelTokenId == null ? "" : "[! " + this.getTokenString(this.headCancelTokenId) + "]") + this.getTokenString(this.headTokenId) + " ... " + this.getTokenString(this.tailTokenId) + " " + this.getTokenString(this.tailEndTokenId);
    }
}

