/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.TreeSearch;
import org.eclipse.draw2dl.geometry.Point;

public class Layer
extends Figure {
    @Override
    public boolean containsPoint(int x, int y) {
        if (this.isOpaque()) {
            return super.containsPoint(x, y);
        }
        Point pt = Point.SINGLETON;
        pt.setLocation(x, y);
        this.translateFromParent(pt);
        x = pt.x;
        y = pt.y;
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = this.getChildren().get(i);
            if (child.containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.isOpaque()) {
            return super.findFigureAt(x, y, search);
        }
        IFigure f = super.findFigureAt(x, y, search);
        if (f == this) {
            return null;
        }
        return f;
    }
}

