/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.text;

import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.text.BidiInfo;
import org.eclipse.draw2dl.text.BidiProcessor;
import org.eclipse.draw2dl.text.FlowContext;
import org.eclipse.draw2dl.text.FlowFigureLayout;

public abstract class FlowFigure
extends Figure {
    protected int selectionStart = -1;

    public FlowFigure() {
        this.setLayoutManager(this.createDefaultFlowLayout());
    }

    @Override
    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        if (this.getLayoutManager() instanceof FlowContext) {
            ((FlowFigure)child).setFlowContext((FlowContext)((Object)this.getLayoutManager()));
        }
        this.revalidateBidi(this);
    }

    public boolean addLeadingWordRequirements(int[] width) {
        return true;
    }

    protected void contributeBidi(BidiProcessor proc) {
        for (IFigure iFigure : this.getChildren()) {
            ((FlowFigure)iFigure).contributeBidi(proc);
        }
    }

    protected abstract FlowFigureLayout createDefaultFlowLayout();

    public abstract void postValidate();

    @Override
    public void remove(IFigure figure) {
        super.remove(figure);
        this.revalidateBidi(this);
    }

    protected void revalidateBidi(IFigure origin) {
        if (this.getParent() != null) {
            ((FlowFigure)this.getParent()).revalidateBidi(origin);
        }
    }

    public void setBidiInfo(BidiInfo info) {
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.bounds.equals(r)) {
            return;
        }
        if (!r.contains(this.bounds)) {
            this.erase();
        }
        this.bounds.x = r.x;
        this.bounds.y = r.y;
        this.bounds.width = r.width;
        this.bounds.height = r.height;
        this.fireFigureMoved();
        if (this.isCoordinateSystem()) {
            this.fireCoordinateSystemChanged();
        }
        this.repaint();
    }

    public void setFlowContext(FlowContext flowContext) {
        ((FlowFigureLayout)this.getLayoutManager()).setFlowContext(flowContext);
    }

    public void setSelection(int start, int end) {
        if (this.selectionStart == start) {
            return;
        }
        this.selectionStart = start;
        this.repaint();
    }
}

