/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.access;

import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConfigurationProfile;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBAAuthProfile
extends DBPConfigurationProfile {
    public static final String PROFILE_KEY_PREFIX = "/auth-profile/";
    private String authModelId;
    private String userName;
    private String userPassword;
    private boolean savePassword;

    public DBAAuthProfile(DBPProject project) {
        super(project);
    }

    public DBAAuthProfile(DBAAuthProfile source) {
        super(source);
        this.authModelId = source.authModelId;
        this.userName = source.userName;
        this.userPassword = source.userPassword;
        this.savePassword = source.savePassword;
    }

    public String getSecretKeyId() {
        return String.valueOf(RMProjectType.getPlainProjectId(this.getProject())) + PROFILE_KEY_PREFIX + this.getProfileId();
    }

    public String getAuthModelId() {
        return this.authModelId;
    }

    public void setAuthModelId(String authModelId) {
        this.authModelId = authModelId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public DBPAuthModelDescriptor getAuthModel() {
        return DBWorkbench.getPlatform().getDataSourceProviderRegistry().getAuthModel(this.authModelId);
    }

    @Override
    public void persistSecrets(DBSSecretController secretController) throws DBException {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("profile-id", this.getProfileId());
        props.put("profile-name", this.getProfileName());
        if (this.getUserName() != null) {
            props.put("user", this.getUserName());
        }
        if (this.getUserPassword() != null) {
            props.put("password", this.getUserPassword());
        }
        if (!CommonUtils.isEmpty(this.getProperties())) {
            props.put("properties", this.getProperties());
        }
        String secretValue = DBInfoUtils.SECRET_GSON.toJson(props);
        secretController.setSecretValue(this.getSecretKeyId(), secretValue);
    }

    @Override
    public void resolveSecrets(DBSSecretController secretController) throws DBException {
        String secretValue = secretController.getSecretValue(this.getSecretKeyId());
        if (secretValue == null) {
            this.loadFromLegacySecret(secretController);
            return;
        }
        Map<String, Object> props = JSONUtils.parseMap(DBInfoUtils.SECRET_GSON, new StringReader(secretValue));
        this.userName = JSONUtils.getString(props, "user");
        this.userPassword = JSONUtils.getString(props, "password");
        this.setProperties(JSONUtils.deserializeStringMap(props, "properties"));
    }

    private void loadFromLegacySecret(DBSSecretController secretController) throws DBException {
    }
}

