/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.utils.CommonUtils;

public class NetworkHandlerDescriptor
extends AbstractContextDescriptor
implements DBWHandlerDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.networkHandler";
    private static final Log log = Log.getLog(NetworkHandlerDescriptor.class);
    private final String id;
    private final String label;
    private final String codeName;
    private final String description;
    private final DBWHandlerType type;
    private final boolean secured;
    private final AbstractDescriptor.ObjectType handlerType;
    private final int order;
    private final List<String> replacesIDs;
    private NetworkHandlerDescriptor replacedBy;
    private final DBPPropertyDescriptor[] properties;

    NetworkHandlerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.codeName = config.getAttribute("codeName") == null ? this.id : config.getAttribute("codeName");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.type = DBWHandlerType.valueOf((String)config.getAttribute("type").toUpperCase(Locale.ENGLISH));
        this.secured = CommonUtils.getBoolean((String)config.getAttribute("secured"), (boolean)false);
        this.handlerType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("handlerClass"));
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"), (int)1);
        this.replacesIDs = Arrays.stream(config.getChildren("replace")).map(re -> re.getAttribute("id")).collect(Collectors.toList());
        this.properties = (DBPPropertyDescriptor[])Arrays.stream(config.getChildren("propertyGroup")).map(PropertyDescriptor::extractProperties).flatMap(Collection::stream).toArray(DBPPropertyDescriptor[]::new);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getCodeName() {
        return this.codeName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBWHandlerType getType() {
        return this.type;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public DBPPropertyDescriptor[] getHandlerProperties() {
        return this.properties;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean matches(DBPDriver driver) {
        try {
            return this.appliesTo((DBPObject)driver.getDataSourceProvider(), driver);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return false;
        }
    }

    public AbstractDescriptor.ObjectType getHandlerType() {
        return this.handlerType;
    }

    public <T extends DBWNetworkHandler> T createHandler(Class<T> impl) throws DBException {
        return (T)((DBWNetworkHandler)this.handlerType.createInstance(impl));
    }

    public boolean replaces(NetworkHandlerDescriptor otherDesc) {
        return this.replacesIDs.contains(otherDesc.id);
    }

    public String toString() {
        return this.id;
    }

    NetworkHandlerDescriptor getReplacedBy() {
        return this.replacedBy;
    }

    void setReplacedBy(NetworkHandlerDescriptor replacedBy) {
        this.replacedBy = replacedBy;
    }
}

