/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLGrant;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class MySQLUser
implements DBAUser,
DBARole,
DBPRefreshableObject,
DBPSaveableObject,
DBPQualifiedObject {
    private static final Log log = Log.getLog(MySQLUser.class);
    private final MySQLDataSource dataSource;
    private String userName;
    private String host;
    private String passwordHash;
    private String sslType;
    private byte[] sslCipher;
    private byte[] x509Issuer;
    private byte[] x509Subject;
    private int maxQuestions;
    private int maxUpdates;
    private int maxConnections;
    private int maxUserConnections;
    private List<MySQLGrant> grants;
    private boolean persisted;

    public MySQLUser(MySQLDataSource dataSource, ResultSet resultSet) {
        this.dataSource = dataSource;
        if (resultSet != null) {
            this.persisted = true;
            this.userName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"user");
            this.host = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"host");
            this.passwordHash = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"password");
            this.sslType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ssl_type");
            this.sslCipher = JDBCUtils.safeGetBytes((ResultSet)resultSet, (String)"ssl_cipher");
            this.x509Issuer = JDBCUtils.safeGetBytes((ResultSet)resultSet, (String)"x509_issuer");
            this.x509Subject = JDBCUtils.safeGetBytes((ResultSet)resultSet, (String)"x509_subject");
            this.maxQuestions = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"max_questions");
            this.maxUpdates = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"max_updates");
            this.maxConnections = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"max_connections");
            this.maxUserConnections = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"max_user_connections");
        } else {
            this.persisted = false;
            this.userName = "";
            this.host = "%";
        }
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return String.valueOf(this.userName) + "@" + this.host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getFullName() {
        return "'" + this.userName + "'@'" + this.host + "'";
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
        DBUtils.fireObjectUpdate((DBSObject)this);
    }

    @Property(viewable=true, order=2)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void clearGrantsCache() {
        this.grants = null;
    }

    /*
     * Exception decompiling
     */
    public List<MySQLGrant> getGrants(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Property(viewable=true, order=20)
    public String getSslType() {
        return this.sslType;
    }

    void setSslType(String sslType) {
        this.sslType = sslType;
    }

    @Property(viewable=true, order=21)
    public byte[] getSslCipher() {
        return this.sslCipher;
    }

    void setSslCipher(byte[] sslCipher) {
        this.sslCipher = sslCipher;
    }

    public byte[] getX509Issuer() {
        return this.x509Issuer;
    }

    void setX509Issuer(byte[] x509Issuer) {
        this.x509Issuer = x509Issuer;
    }

    public byte[] getX509Subject() {
        return this.x509Subject;
    }

    void setX509Subject(byte[] x509Subject) {
        this.x509Subject = x509Subject;
    }

    @Property(viewable=true, order=22)
    public int getMaxQuestions() {
        return this.maxQuestions;
    }

    public void setMaxQuestions(int maxQuestions) {
        this.maxQuestions = maxQuestions;
    }

    @Property(viewable=true, order=23)
    public int getMaxUpdates() {
        return this.maxUpdates;
    }

    public void setMaxUpdates(int maxUpdates) {
        this.maxUpdates = maxUpdates;
    }

    @Property(viewable=true, order=24)
    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Property(viewable=true, order=25)
    public int getMaxUserConnections() {
        return this.maxUserConnections;
    }

    public void setMaxUserConnections(int maxUserConnections) {
        this.maxUserConnections = maxUserConnections;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.grants = null;
        return this;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)this.userName, (boolean)false, (boolean)true)) + "@" + DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)this.host, (boolean)false, (boolean)true);
    }
}

