/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.jkiss.code.NotNull;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private final ImageDescriptor baseImage;
    private CompositeImageDescriptor.CachedImageDataProvider baseImageDataProvider = null;
    private Point baseImageSize = null;
    private ImageDescriptor[] topLeft;
    private ImageDescriptor[] topRight;
    private ImageDescriptor[] bottomLeft;
    private ImageDescriptor[] bottomRight;

    public OverlayImageDescriptor(@NotNull ImageDescriptor baseImage) {
        this.baseImage = baseImage;
    }

    public void setTopLeft(ImageDescriptor[] topLeft) {
        this.topLeft = topLeft;
    }

    public void setTopRight(ImageDescriptor[] topRight) {
        this.topRight = topRight;
    }

    public void setBottomLeft(ImageDescriptor[] bottomLeft) {
        this.bottomLeft = bottomLeft;
    }

    public void setBottomRight(ImageDescriptor[] bottomRight) {
        this.bottomRight = bottomRight;
    }

    @NotNull
    private CompositeImageDescriptor.CachedImageDataProvider getBaseImageData() {
        if (this.baseImageDataProvider == null) {
            this.baseImageDataProvider = this.createCachedImageDataProvider(this.baseImage);
        }
        return this.baseImageDataProvider;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage((ImageDataProvider)this.getBaseImageData(), 0, 0);
        if (this.topRight != null) {
            this.drawTopRight(this.topRight);
        }
        if (this.bottomRight != null) {
            this.drawBottomRight(this.bottomRight);
        }
        if (this.bottomLeft != null) {
            this.drawBottomLeft(this.bottomLeft);
        }
        if (this.topLeft != null) {
            this.drawTopLeft(this.topLeft);
        }
    }

    @NotNull
    protected Point getSize() {
        if (this.baseImageSize == null) {
            CompositeImageDescriptor.CachedImageDataProvider idp = this.getBaseImageData();
            this.baseImageSize = new Point(idp.getWidth(), idp.getHeight());
        }
        return this.baseImageSize;
    }

    private void drawTopLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x, 0);
                x += idp.getWidth();
            }
            ++i;
        }
    }

    private void drawTopRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x -= idp.getWidth(), 0);
            }
            --i;
        }
    }

    private void drawBottomLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x, this.getSize().y - idp.getHeight());
                x += idp.getWidth();
            }
            ++i;
        }
    }

    private void drawBottomRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x -= idp.getWidth(), this.getSize().y - idp.getHeight());
            }
            --i;
        }
    }
}

