/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.VerticalFolder;
import org.jkiss.utils.CommonUtils;

public class VerticalButton
extends Canvas {
    public static final int BORDER_MARGIN = 2;
    public static final int VERT_INDENT = 8;
    private static final Point EMPTY_SIZE = new Point(0, 0);
    private static final boolean IS_TRANSFORM_BUG_PRESENT = false;
    private int mouse = 0;
    private boolean hit = false;
    private String text = "";
    private Image image = null;
    private Image imageDisabled = null;
    private boolean isHover;
    private IAction action;
    private IServiceLocator serviceLocator;
    private String commandId;
    private ICommandListener commandListener;
    private boolean checked;

    public VerticalButton(VerticalFolder parent, int style) {
        super((Composite)parent, style | 0x80000);
        this.setLayoutData(new GridData(64));
        parent.addItem(this);
        this.addPaintListener(this::paint);
        this.addMouseMoveListener(e -> {
            if (!this.isHover) {
                this.isHover = true;
                this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                VerticalButton.this.isHover = true;
                VerticalButton.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                VerticalButton.this.isHover = false;
                VerticalButton.this.redraw();
            }

            public void mouseHover(MouseEvent e) {
                if (!VerticalButton.this.isHover) {
                    VerticalButton.this.isHover = true;
                    VerticalButton.this.redraw();
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                VerticalButton.this.isHover = true;
                VerticalButton.this.hit = true;
                VerticalButton.this.redraw();
            }

            public void mouseUp(MouseEvent e) {
                VerticalButton.this.isHover = true;
                VerticalButton.this.redraw();
                if (VerticalButton.this.hit) {
                    Event event = new Event();
                    event.widget = event.item = VerticalButton.this;
                    VerticalButton.this.runAction(event);
                }
                VerticalButton.this.hit = false;
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.character == ' ') {
                    Event event = new Event();
                    event.widget = event.item = VerticalButton.this;
                    VerticalButton.this.runAction(event);
                }
            }
        });
        this.addDisposeListener(e -> {
            this.getFolder().removeItem(this);
            if (this.commandId != null) {
                this.removeCommandListener(this.commandId);
            }
        });
    }

    private void runAction(Event event) {
        this.notifyListeners(13, event);
        if ((this.getStyle() & 0x10) == 16) {
            this.getFolder().setSelection(this);
        }
        if (this.action != null) {
            if (this.action.isEnabled()) {
                this.action.runWithEvent(event);
                this.redraw();
            }
        } else if (this.commandId != null && ActionUtils.isCommandEnabled(this.commandId, this.serviceLocator)) {
            ActionUtils.runCommand(this.commandId, this.serviceLocator);
        }
    }

    public VerticalFolder getFolder() {
        return (VerticalFolder)this.getParent();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.redraw();
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    private void setImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            this.image = imageDescriptor.createImage(true);
            this.addDisposeListener(e -> UIUtils.dispose((Resource)this.image));
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this);
        try {
            Point point = this.computeSize(gc, wHint, hHint, changed);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    public Point computeSize(GC gc, int wHint, int hHint, boolean changed) {
        String text = this.getText();
        Point textSize = CommonUtils.isEmpty((String)text) ? EMPTY_SIZE : gc.stringExtent(text);
        Point iconSize = EMPTY_SIZE;
        if (this.image != null) {
            Rectangle imageBounds = this.image.getBounds();
            iconSize = new Point(imageBounds.width + 2, imageBounds.height + 4);
            if (textSize == EMPTY_SIZE) {
                return iconSize;
            }
        }
        return new Point(Math.max(iconSize.y, textSize.y + 4), textSize.x + 20 + iconSize.x);
    }

    public void paint(PaintEvent e) {
        boolean selected = this.isSelected();
        Point size = this.computeSize(e.gc, -1, -1, false);
        boolean enabled = true;
        if (this.getFolder().isCheckCommandEnablement()) {
            if (this.action != null && !this.action.isEnabled()) {
                enabled = false;
            } else if (this.commandId != null) {
                enabled = ActionUtils.isCommandEnabled(this.commandId, this.serviceLocator);
            }
        }
        if (enabled && (selected || this.isHover)) {
            RGB blendRGB;
            Color curBackground = e.gc.getBackground();
            boolean isDarkBG = UIUtils.isDark(curBackground.getRGB());
            RGB rGB = blendRGB = isDarkBG ? new RGB(255, 255, 255) : new RGB(0, 0, 0);
            if (this.isHover) {
                RGB buttonHoverRGB = UIUtils.blend(curBackground.getRGB(), blendRGB, 90);
                Color buttonHoverColor = UIUtils.getSharedTextColors().getColor(buttonHoverRGB);
                e.gc.setBackground(buttonHoverColor);
                e.gc.fillRectangle(0, 0, size.x, size.y);
            }
            if (selected) {
                if (!this.isHover) {
                    RGB selectedBackRGB = UIUtils.blend(curBackground.getRGB(), blendRGB, 95);
                    Color selectedBackColor = UIUtils.getSharedTextColors().getColor(selectedBackRGB);
                    e.gc.setBackground(selectedBackColor);
                    e.gc.fillRectangle(0, 0, size.x, size.y);
                }
                e.gc.setForeground(this.getDisplay().getSystemColor(18));
                e.gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
            }
        }
        int xOffset = 0;
        int yOffset = 2;
        Transform transform = null;
        String text = this.getText();
        if (!CommonUtils.isEmpty((String)text)) {
            boolean shiftOffset = false;
            transform = new Transform((Device)e.display);
            e.gc.setAntialias(1);
            if ((this.getStyle() & 0x20000) == 131072) {
                transform.translate((float)size.x, 0.0f);
                transform.rotate(90.0f);
                if (shiftOffset) {
                    yOffset -= size.x / 2;
                }
            } else {
                transform.translate(0.0f, (float)size.y);
                transform.rotate(-90.0f);
                if (shiftOffset) {
                    xOffset -= size.y / 2;
                }
            }
            e.gc.setTransform(transform);
            xOffset += 8;
        }
        if (this.image != null) {
            if (!enabled) {
                if (this.imageDisabled == null) {
                    this.imageDisabled = new Image((Device)e.display, this.image, 2);
                    this.addDisposeListener(e1 -> this.imageDisabled.dispose());
                }
                e.gc.drawImage(this.imageDisabled, xOffset, yOffset);
            } else {
                e.gc.drawImage(this.image, xOffset, yOffset);
            }
            xOffset += this.image.getBounds().width + 2;
        }
        if (!CommonUtils.isEmpty((String)text)) {
            e.gc.setForeground(UIStyles.getDefaultTextForeground());
            e.gc.drawString(this.text, xOffset, yOffset);
        }
        if (transform != null) {
            transform.dispose();
        }
    }

    private boolean isSelected() {
        return this.checked || (this.getStyle() & 0x10) == 16 && this.getFolder().getSelection() == this || this.action != null && (this.action.getStyle() & 2) == 2 && this.action.isChecked();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addListener(13, event -> listener.widgetSelected(new SelectionEvent(event)));
    }

    public IAction getAction() {
        return this.action;
    }

    public void setAction(IAction action, boolean showText) {
        String toolTipText;
        this.action = action;
        this.setImage(action.getImageDescriptor());
        if (showText) {
            this.text = action.getText();
        }
        if (!CommonUtils.isEmpty((String)(toolTipText = action.getToolTipText()))) {
            this.setToolTipText(toolTipText);
        }
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommand(IServiceLocator serviceLocator, String commandId, boolean showText) {
        String toolTipText;
        if (this.commandId != null) {
            this.removeCommandListener(this.commandId);
        }
        this.setCommandListener(commandId);
        this.serviceLocator = serviceLocator;
        this.commandId = commandId;
        this.setImage(ActionUtils.findCommandImage(commandId));
        if (showText) {
            this.text = ActionUtils.findCommandName(commandId);
        }
        if (!CommonUtils.isEmpty((String)(toolTipText = ActionUtils.findCommandDescription(commandId, serviceLocator, false)))) {
            this.setToolTipText(toolTipText);
        }
    }

    private void setCommandListener(@NotNull String commandId) {
        Command command = ActionUtils.findCommand(commandId);
        if (command != null) {
            this.commandListener = event -> {
                String toolTipText = ActionUtils.findCommandDescription(commandId, this.serviceLocator, false);
                if (CommonUtils.isNotEmpty((String)toolTipText)) {
                    this.setToolTipText(toolTipText);
                }
            };
            command.addCommandListener(this.commandListener);
        }
    }

    private void removeCommandListener(@NotNull String commandId) {
        Command command = ActionUtils.findCommand(commandId);
        if (command != null && this.commandListener != null) {
            command.removeCommandListener(this.commandListener);
            this.commandListener = null;
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean selection) {
        this.checked = selection;
    }

    public static VerticalButton create(VerticalFolder folder, int style, IServiceLocator serviceLocator, String commandId, boolean showText) {
        VerticalButton button = new VerticalButton(folder, style);
        button.setCommand(serviceLocator, commandId, showText);
        return button;
    }

    public static VerticalButton create(VerticalFolder folder, int style, IAction action, boolean showText) {
        VerticalButton button = new VerticalButton(folder, style);
        button.setAction(action, showText);
        return button;
    }
}

