/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.xfer.InMemoryDestFile;
import net.schmizz.sshj.xfer.InMemorySourceFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.DBeaverAuthAgent;
import org.jkiss.dbeaver.model.net.ssh.KnownHostsVerifier;
import org.jkiss.dbeaver.model.net.ssh.SSHAgentIdentity;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SSHImplementationSshj
extends SSHImplementationAbstract {
    private static final Log log = Log.getLog(SSHImplementationSshj.class);
    private final List<LocalPortListener> listeners = new ArrayList<LocalPortListener>();
    private SSHClient[] clients;

    protected synchronized void setupTunnel(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration[] hosts, @NotNull SSHPortForwardConfiguration portForward) throws DBException {
        this.clients = new SSHClient[hosts.length];
        int connectTimeout = configuration.getIntProperty("sshConnectTimeout");
        int keepAliveInterval = configuration.getIntProperty("aliveInterval");
        int index = 0;
        while (index < hosts.length) {
            SSHHostConfiguration host = hosts[index];
            SSHAuthConfiguration auth = host.getAuthConfiguration();
            SSHClient client = new SSHClient();
            client.setConnectTimeout(connectTimeout);
            client.getConnection().getKeepAlive().setKeepAliveInterval(keepAliveInterval);
            try {
                SSHImplementationSshj.setupHostKeyVerification(client, configuration);
            }
            catch (IOException e) {
                log.debug((Object)("Error loading known hosts: " + e.getMessage()));
            }
            try {
                if (index > 0) {
                    int port = this.setPortForwarding(this.clients[index - 1], host.getHostname(), host.getPort());
                    monitor.subTask(String.format("Instantiate tunnel %s:%d -> %s:%d", hosts[index - 1].getHostname(), port, host.getHostname(), host.getPort()));
                    client.connect("localhost", port);
                } else {
                    monitor.subTask(String.format("Instantiate tunnel to %s:%d", host.getHostname(), host.getPort()));
                    client.connect(host.getHostname(), host.getPort());
                }
                switch (auth.getType()) {
                    case PASSWORD: {
                        client.authPassword(host.getUsername(), auth.getPassword());
                        break;
                    }
                    case PUBLIC_KEY: {
                        if (auth.getKeyFile() != null) {
                            String location = auth.getKeyFile().toAbsolutePath().toString();
                            if (CommonUtils.isEmpty((String)auth.getPassword())) {
                                client.authPublickey(host.getUsername(), new String[]{location});
                                break;
                            }
                            client.authPublickey(host.getUsername(), new KeyProvider[]{client.loadKeys(location, auth.getPassword().toCharArray())});
                            break;
                        }
                        PasswordFinder finder = CommonUtils.isEmpty((String)auth.getPassword()) ? null : PasswordUtils.createOneOff((char[])auth.getPassword().toCharArray());
                        client.authPublickey(host.getUsername(), new KeyProvider[]{client.loadKeys(auth.getKeyValue(), null, finder)});
                        break;
                    }
                    case AGENT: {
                        ArrayList<DBeaverAuthAgent> methods = new ArrayList<DBeaverAuthAgent>();
                        for (SSHAgentIdentity identity : this.getAgentData()) {
                            methods.add(new DBeaverAuthAgent(this, identity));
                        }
                        client.auth(host.getUsername(), methods);
                        break;
                    }
                }
                if (index == hosts.length - 1) {
                    log.debug((Object)String.format("Set port forwarding %s:%d -> %s:%d", portForward.getLocalHost(), portForward.getLocalPort(), portForward.getRemoteHost(), portForward.getRemotePort()));
                    this.setPortForwarding(client, portForward.getLocalHost(), portForward.getLocalPort(), portForward.getRemoteHost(), portForward.getRemotePort());
                }
            }
            catch (IOException e) {
                this.closeTunnel(monitor);
                throw new DBException("Cannot establish tunnel to " + host.getHostname() + ":" + host.getPort(), (Throwable)e);
            }
            this.clients[index] = client;
            ++index;
        }
    }

    private static void setupHostKeyVerification(@NotNull SSHClient client, @NotNull DBWHandlerConfiguration configuration) throws IOException {
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode() || configuration.getBooleanProperty("bypassHostVerification")) {
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        } else {
            client.addHostKeyVerifier((HostKeyVerifier)new KnownHostsVerifier(SSHUtils.getKnownSshHostsFileOrDefault(), DBWorkbench.getPlatformUI()));
        }
        client.loadKnownHosts();
    }

    public synchronized void closeTunnel(DBRProgressMonitor monitor) {
        this.listeners.forEach(LocalPortListener::disconnect);
        this.listeners.clear();
        RuntimeUtils.runTask(monitor1 -> {
            Object[] clients = this.clients;
            if (ArrayUtils.isEmpty((Object[])clients)) {
                return;
            }
            Object[] objectArray = clients;
            int n = clients.length;
            int n2 = 0;
            while (n2 < n) {
                Object client = objectArray[n2];
                if (client != null && client.isConnected()) {
                    try {
                        client.disconnect();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Error closing session: " + e.getMessage()));
                    }
                }
                ++n2;
            }
        }, (String)"Close SSH session", (long)1000L);
        this.clients = null;
    }

    public String getClientVersion() {
        return ArrayUtils.isEmpty((Object[])this.clients) ? null : this.clients[this.clients.length - 1].getTransport().getClientVersion();
    }

    public String getServerVersion() {
        return ArrayUtils.isEmpty((Object[])this.clients) ? null : this.clients[this.clients.length - 1].getTransport().getServerVersion();
    }

    public void invalidateTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        this.closeTunnel(monitor);
        this.initTunnel(monitor, this.savedConfiguration, this.savedConnectionInfo);
    }

    public void getFile(@NotNull String src, final @NotNull OutputStream dst, @NotNull DBRProgressMonitor monitor) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (SFTPClient client = this.openSftpClient();){
            client.get(src, (LocalDestFile)new InMemoryDestFile(){

                public long getLength() {
                    return -1L;
                }

                public OutputStream getOutputStream() {
                    return dst;
                }

                public OutputStream getOutputStream(boolean b) {
                    return dst;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void putFile(final @NotNull InputStream src, @NotNull String dst, @NotNull DBRProgressMonitor monitor) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (SFTPClient client = this.openSftpClient();){
            client.put((LocalSourceFile)new InMemorySourceFile(){

                public String getName() {
                    return "memory";
                }

                public long getLength() {
                    return -1L;
                }

                public InputStream getInputStream() {
                    return src;
                }
            }, dst);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    private SFTPClient openSftpClient() throws DBException, IOException {
        if (ArrayUtils.isEmpty((Object[])this.clients)) {
            throw new DBException("No active session available");
        }
        return this.clients[this.clients.length - 1].newSFTPClient();
    }

    private int setPortForwarding(@NotNull SSHClient client, String host, int port) throws IOException {
        return this.setPortForwarding(client, "127.0.0.1", 0, host, port);
    }

    private int setPortForwarding(@NotNull SSHClient client, @NotNull String localHost, int localPort, @NotNull String remoteHost, int remotePort) throws IOException {
        ServerSocket ss = new ServerSocket(localPort, 0, InetAddress.getByName(localHost));
        Parameters parameters = new Parameters(localHost, ss.getLocalPort(), remoteHost, remotePort);
        LocalPortForwarder forwarder = client.newLocalPortForwarder(parameters, ss);
        LocalPortListener listener = new LocalPortListener(forwarder, parameters);
        listener.start();
        this.listeners.add(listener);
        return ss.getLocalPort();
    }

    private static class LocalPortListener
    extends Thread {
        private final LocalPortForwarder forwarder;

        public LocalPortListener(@NotNull LocalPortForwarder forwarder, @NotNull Parameters parameters) {
            this.forwarder = forwarder;
            this.setName(String.format("Port forwarder listener (%s:%d -> %s:%d)", parameters.getLocalHost(), parameters.getLocalPort(), parameters.getRemoteHost(), parameters.getRemotePort()));
        }

        @Override
        public void run() {
            try {
                this.forwarder.listen();
            }
            catch (IOException e) {
                log.error((Object)"Error while listening on the port forwarder", (Throwable)e);
            }
        }

        public void disconnect() {
            try {
                if (this.forwarder.isRunning()) {
                    this.forwarder.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while stopping port forwarding", (Throwable)e);
            }
        }
    }
}

