/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.views;

import java.util.Map;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableCheckConstraint;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class GenericTablePrimaryKeyConfigurator
implements DBEObjectConfigurator<GenericUniqueKey> {
    public GenericUniqueKey configureObject(DBRProgressMonitor monitor, Object table, final GenericUniqueKey primaryKey, Map<String, Object> options) {
        final boolean isSupportCheckConstraint = primaryKey.getDataSource().getMetaModel().supportsCheckConstraints();
        return (GenericUniqueKey)new UITask<GenericUniqueKey>(){

            protected GenericUniqueKey runTask() {
                DBSEntityConstraintType[] dBSEntityConstraintTypeArray;
                if (isSupportCheckConstraint) {
                    DBSEntityConstraintType[] dBSEntityConstraintTypeArray2 = new DBSEntityConstraintType[3];
                    dBSEntityConstraintTypeArray2[0] = DBSEntityConstraintType.PRIMARY_KEY;
                    dBSEntityConstraintTypeArray2[1] = DBSEntityConstraintType.UNIQUE_KEY;
                    dBSEntityConstraintTypeArray = dBSEntityConstraintTypeArray2;
                    dBSEntityConstraintTypeArray2[2] = DBSEntityConstraintType.CHECK;
                } else {
                    DBSEntityConstraintType[] dBSEntityConstraintTypeArray3 = new DBSEntityConstraintType[2];
                    dBSEntityConstraintTypeArray3[0] = DBSEntityConstraintType.PRIMARY_KEY;
                    dBSEntityConstraintTypeArray = dBSEntityConstraintTypeArray3;
                    dBSEntityConstraintTypeArray3[1] = DBSEntityConstraintType.UNIQUE_KEY;
                }
                EditConstraintPage editPage = new EditConstraintPage("Create unique constraint", (DBSEntityConstraint)primaryKey, dBSEntityConstraintTypeArray);
                if (!editPage.edit()) {
                    return null;
                }
                primaryKey.setConstraintType(editPage.getConstraintType());
                primaryKey.setName(editPage.getConstraintName());
                if (primaryKey instanceof DBSTableCheckConstraint) {
                    ((DBSTableCheckConstraint)primaryKey).setCheckConstraintDefinition(editPage.getConstraintExpression());
                }
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    primaryKey.addColumn(new GenericTableConstraintColumn((JDBCTableConstraint)primaryKey, (GenericTableColumn)tableColumn, colIndex++));
                }
                return primaryKey;
            }
        }.execute();
    }
}

