/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.completion;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionContext;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionHelper;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionProposalBase {
    public static final String PARAM_EXEC = "exec";
    private static final Log log = Log.getLog(SQLCompletionProposalBase.class);
    private final SQLCompletionContext context;
    private String displayString;
    protected String replacementString;
    protected String replacementFull;
    protected String replacementAfter;
    protected int replacementOffset;
    protected int replacementLength;
    protected int cursorPosition;
    private DBPKeywordType proposalType;
    private Object additionalProposalInfo;
    private DBPImage image;
    private DBPNamedObject object;
    private Map<String, Object> params;
    private int proposalScore;

    public SQLCompletionProposalBase(SQLCompletionContext context, SQLWordPartDetector wordPartDetector, String displayString, String replacementString, int cursorPosition, @Nullable DBPImage image, DBPKeywordType proposalType, String description, DBPNamedObject object, Map<String, Object> params) {
        this.context = context;
        DBPDataSource dataSource = context.getDataSource();
        this.displayString = displayString;
        this.replacementString = replacementString;
        this.replacementFull = dataSource == null ? replacementString : DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)replacementString.toLowerCase(Locale.ENGLISH));
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.proposalType = proposalType;
        this.additionalProposalInfo = object;
        this.setPosition(wordPartDetector);
        this.object = object;
        this.params = params;
    }

    public SQLCompletionContext getContext() {
        return this.context;
    }

    public DBPDataSource getDataSource() {
        return this.context.getDataSource();
    }

    public DBPNamedObject getObject() {
        return this.object;
    }

    protected void setPosition(SQLWordPartDetector wordDetector) {
        boolean useFQName;
        String fullWord = wordDetector.getFullWord();
        int curOffset = wordDetector.getCursorOffset() - wordDetector.getStartOffset();
        char structSeparator = this.context.getSyntaxManager().getStructSeparator();
        DBPDataSource dataSource = this.context.getDataSource();
        boolean bl = useFQName = dataSource != null && this.context.isUseFQNames() && this.replacementString.indexOf(structSeparator) != -1;
        if (useFQName) {
            this.replacementOffset = wordDetector.getStartOffset();
            this.replacementLength = wordDetector.getLength();
        } else if (!fullWord.equals(this.replacementString) && !this.replacementString.contains(String.valueOf(structSeparator))) {
            int startOffset = fullWord.lastIndexOf(structSeparator, curOffset - 1);
            startOffset = startOffset == -1 ? 0 : (startOffset > curOffset ? ((startOffset = fullWord.lastIndexOf(structSeparator, curOffset)) == -1 ? curOffset : ++startOffset) : ++startOffset);
            int endOffset = fullWord.indexOf(structSeparator, curOffset);
            endOffset = endOffset != -1 ? fullWord.length() - endOffset : 0;
            this.replacementOffset = wordDetector.getStartOffset() + startOffset;
            boolean replaceWord = dataSource != null && this.context.isReplaceWords();
            this.replacementLength = replaceWord ? wordDetector.getEndOffset() - this.replacementOffset - endOffset : curOffset - startOffset;
            if (dataSource != null && DBUtils.isQuotedIdentifier((DBPDataSource)dataSource, (String)fullWord)) {
                ++this.replacementLength;
            }
        } else {
            int startOffset = fullWord.indexOf(structSeparator);
            int endOffset = fullWord.indexOf(structSeparator, curOffset);
            if (endOffset == startOffset) {
                startOffset = -1;
            }
            startOffset = startOffset != -1 ? (startOffset += wordDetector.getStartOffset() + 1) : wordDetector.getStartOffset();
            endOffset = endOffset != -1 ? (endOffset += wordDetector.getStartOffset()) : (wordDetector.getWordPart().isEmpty() ? wordDetector.getCursorOffset() : wordDetector.getEndOffset());
            this.replacementOffset = startOffset;
            this.replacementLength = endOffset - startOffset;
        }
    }

    public String getExtraString() {
        try {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            if (this.object instanceof DBSObjectReference && DBSProcedure.class.isAssignableFrom(((DBSObjectReference)this.object).getObjectType().getTypeClass())) {
                this.object = ((DBSObjectReference)this.object).resolveObject((DBRProgressMonitor)monitor);
            }
            if (this.object instanceof DBSProcedure) {
                boolean isExec = CommonUtils.toBoolean((Object)this.params.get(PARAM_EXEC));
                Collection parameters = ((DBSProcedure)this.object).getParameters((DBRProgressMonitor)monitor);
                if (!CommonUtils.isEmpty((Collection)parameters)) {
                    StringBuilder params = new StringBuilder();
                    for (DBSProcedureParameter param : parameters) {
                        if (!param.getParameterKind().isInput()) continue;
                        if (params.length() > 0) {
                            params.append(", ");
                        }
                        if (isExec) {
                            params.append(":").append(param.getName());
                            continue;
                        }
                        params.append(param.getParameterType().getFullTypeName());
                    }
                    return "(" + params.toString() + ")";
                }
                return "()";
            }
            return null;
        }
        catch (DBException e) {
            log.error((Object)"Error resolving procedure parameters", (Throwable)e);
            return null;
        }
    }

    public Object getAdditionalInfo(DBRProgressMonitor monitor) {
        if (this.additionalProposalInfo == null && this.object == null) {
            this.additionalProposalInfo = SQLCompletionHelper.readAdditionalProposalInfo(monitor, this.context, this.object, new String[]{this.displayString}, this.proposalType);
        }
        return this.object != null ? this.object : this.additionalProposalInfo;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public DBPKeywordType getProposalType() {
        return this.proposalType;
    }

    public DBPImage getObjectImage() {
        return this.image;
    }

    public boolean hasStructObject() {
        return this.object instanceof DBSObject || this.object instanceof DBSObjectReference;
    }

    public DBSObject getObjectContainer() {
        if (this.object instanceof DBSObject) {
            return ((DBSObject)this.object).getParentObject();
        }
        if (this.object instanceof DBSObjectReference) {
            return ((DBSObjectReference)this.object).getContainer();
        }
        return null;
    }

    public void setReplacementAfter(String replacementAfter) {
        this.replacementAfter = replacementAfter;
    }

    public int getProposalScore() {
        return this.proposalScore;
    }

    public void setProposalScore(int proposalScore) {
        this.proposalScore = proposalScore;
    }

    public String toString() {
        return this.displayString;
    }
}

