/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.dataset.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.dataset.DBDDataSet;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatasetStorage {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_DRAFT = "draft";
    public static final String ATTR_DATA_SOURCE = "data-source";
    private DBDDataSet dataSet;

    public DatasetStorage(DBDDataSet dataSet) {
        this.dataSet = dataSet;
    }

    public DatasetStorage(Path file) throws DBException, CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream contents = Files.newInputStream(file, new OpenOption[0]);){
                Document document = XMLUtils.parseDocument((InputStream)contents);
                Element root = document.getDocumentElement();
                this.dataSet = new DBDDataSet(IOUtils.getFileNameWithoutExtension((Path)file), root.getAttribute(ATTR_NAME));
                this.dataSet.setDescription(root.getAttribute(ATTR_DESCRIPTION));
                this.dataSet.setDraft(CommonUtils.toBoolean((Object)root.getAttribute(ATTR_DRAFT)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("IO Error reading dataset from '" + file.toAbsolutePath().toString() + "'", (Throwable)e);
        }
    }

    public DBDDataSet getDataSet() {
        return this.dataSet;
    }

    public ByteArrayInputStream serialize() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(5000);
        XMLBuilder xml = new XMLBuilder((OutputStream)buffer, GeneralUtils.getDefaultFileEncoding());
        xml.startElement("dataset");
        xml.addAttribute(ATTR_NAME, this.dataSet.getDisplayName());
        if (this.dataSet.getDescription() != null) {
            xml.addAttribute(ATTR_DESCRIPTION, this.dataSet.getDescription());
        }
        xml.endElement();
        xml.flush();
        return new ByteArrayInputStream(buffer.toByteArray());
    }
}

