/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ClearHistoryHandler
extends AbstractHandler {
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.clearHistoryHandler";
    private final Map<String, HandlerDescriptor> descriptors = new LinkedHashMap<String, HandlerDescriptor>();

    public ClearHistoryHandler() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("handler".equals(element.getName())) {
                HandlerDescriptor descriptor = new HandlerDescriptor(element);
                this.descriptors.put(descriptor.id, descriptor);
            }
            ++n2;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ClearHistoryDialog dialog = new ClearHistoryDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (dialog.open() != 0) {
            return null;
        }
        if (PlatformUI.getWorkbench().restart()) {
            for (String option : dialog.options) {
                HandlerDescriptor descriptor = this.descriptors.get(option);
                try {
                    UIUtils.runInProgressDialog((DBRRunnableWithProgress)descriptor.getHandler());
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError(CoreApplicationMessages.clear_history_error_title, NLS.bind((String)CoreApplicationMessages.clear_history_error_message, (Object)descriptor.name), e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e);
                }
            }
        }
        return null;
    }

    private class ClearHistoryDialog
    extends BaseDialog {
        private final Set<String> options;

        public ClearHistoryDialog(Shell shell) {
            super(shell, CoreApplicationMessages.clear_history_dialog_title, null);
            this.options = new HashSet<String>();
            this.setShellStyle(2144);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            UIUtils.createLabel((Composite)composite, (String)CoreApplicationMessages.clear_history_dialog_message);
            Group group = UIUtils.createControlGroup((Composite)composite, (String)CoreApplicationMessages.clear_history_dialog_options, (int)1, (int)1808, (int)0);
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button checkbox = (Button)e.widget;
                    HandlerDescriptor descriptor = (HandlerDescriptor)((Object)checkbox.getData());
                    if (checkbox.getSelection()) {
                        ClearHistoryDialog.this.options.add(descriptor.id);
                    } else {
                        ClearHistoryDialog.this.options.remove(descriptor.id);
                    }
                    Button button = ClearHistoryDialog.this.getButton(0);
                    if (button != null) {
                        button.setEnabled(!ClearHistoryDialog.this.options.isEmpty());
                    }
                }
            };
            for (HandlerDescriptor descriptor : ClearHistoryHandler.this.descriptors.values()) {
                Button checkbox = UIUtils.createCheckbox((Composite)group, (String)descriptor.name, (String)descriptor.description, (boolean)false, (int)1);
                checkbox.setData((Object)descriptor);
                checkbox.addSelectionListener((SelectionListener)listener);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, CoreApplicationMessages.clear_history_dialog_apply_and_restart, true).setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    private static class HandlerDescriptor
    extends AbstractDescriptor {
        public static final String ELEMENT_ID = "handler";
        private final String id;
        private final String name;
        private final String description;
        private final AbstractDescriptor.ObjectType handler;

        public HandlerDescriptor(@NotNull IConfigurationElement config) {
            super(config);
            this.id = config.getAttribute("id");
            this.name = config.getAttribute("name");
            this.description = config.getAttribute("description");
            this.handler = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute(ELEMENT_ID));
        }

        @NotNull
        public DBRRunnableWithProgress getHandler() throws DBException {
            this.handler.checkObjectClass(DBRRunnableWithProgress.class);
            try {
                return (DBRRunnableWithProgress)this.handler.getObjectClass(DBRRunnableWithProgress.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new DBException("Can't create instance", e);
            }
        }
    }
}

