/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class SQLTemplateStore
extends TemplateStore {
    private static final Log log = Log.getLog(SQLTemplateStore.class);
    public static final String PREF_STORE_KEY = "org.jkiss.dbeaver.core.sql_templates";
    private final CustomTemplatesStore customTemplatesStore;

    private SQLTemplateStore(ContextTypeRegistry registry, CustomTemplatesStore customTemplatesStore) {
        super(registry, (IPreferenceStore)new PreferenceStoreDelegate((DBPPreferenceStore)customTemplatesStore), PREF_STORE_KEY);
        this.customTemplatesStore = customTemplatesStore;
    }

    @NotNull
    public Set<String> getCustomTemplateNames() {
        try {
            String pref = this.customTemplatesStore.getString(PREF_STORE_KEY);
            if (pref != null && !pref.trim().isEmpty()) {
                StringReader input = new StringReader(pref);
                TemplateReaderWriter reader = new TemplateReaderWriter();
                return Stream.of(reader.read((Reader)input)).map(t -> t.getTemplate().getName()).collect(Collectors.toSet());
            }
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load custom template names", (Throwable)ex);
        }
        return Collections.emptySet();
    }

    @NotNull
    public static SQLTemplateStore createInstance(@NotNull ContextTypeRegistry registry) {
        return new SQLTemplateStore(registry, new CustomTemplatesStore());
    }

    protected void loadContributedTemplates() throws IOException {
        Collection<TemplatePersistenceData> contributed = this.readContributedTemplates();
        for (TemplatePersistenceData data : contributed) {
            this.internalAdd(data);
        }
    }

    private Collection<TemplatePersistenceData> readContributedTemplates() throws IOException {
        ArrayList<TemplatePersistenceData> templates = new ArrayList<TemplatePersistenceData>();
        this.readIncludedTemplates("org.jkiss.dbeaver.ui.editors.sql", templates, "templates/default-templates.xml", "$nl$/templates/default-templates.properties");
        for (DBPDataSourceProviderDescriptor provider : DBWorkbench.getPlatform().getDataSourceProviderRegistry().getDataSourceProviders()) {
            this.readIncludedTemplates(provider.getPluginId(), templates, "templates/" + provider.getId() + "-templates.xml", "$nl$/templates/" + provider.getId() + "-templates.properties");
        }
        return templates;
    }

    private void readIncludedTemplates(String contributorId, Collection<TemplatePersistenceData> templates, String file, String translations) throws IOException {
        Bundle plugin;
        URL url;
        if (file != null && (url = FileLocator.find((Bundle)(plugin = Platform.getBundle((String)contributorId)), (IPath)Path.fromOSString((String)file), null)) != null) {
            URL bundleURL;
            PropertyResourceBundle bundle = null;
            if (translations != null && (bundleURL = FileLocator.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations), null)) != null) {
                InputStream bundleStream = bundleURL.openStream();
                try {
                    bundle = new PropertyResourceBundle(bundleStream);
                }
                finally {
                    ContentUtils.close((Closeable)bundleStream);
                }
            }
            BufferedInputStream stream = new BufferedInputStream(url.openStream());
            try {
                TemplatePersistenceData[] datas;
                TemplateReaderWriter reader = new TemplateReaderWriter();
                TemplatePersistenceData[] templatePersistenceDataArray = datas = reader.read((InputStream)stream, bundle);
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplatePersistenceData data = templatePersistenceDataArray[n2];
                    if (data.isCustom()) {
                        if (data.getId() == null) {
                            log.error((Object)"No template id specified");
                        } else {
                            log.error((Object)("Template " + data.getTemplate().getName() + " deleted"));
                        }
                    } else if (this.validateTemplate(data.getTemplate())) {
                        templates.add(data);
                    }
                    ++n2;
                }
            }
            finally {
                ContentUtils.close((Closeable)stream);
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (!this.contextExists(contextTypeId)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
            }
            catch (TemplateException e) {
                log.error((Object)("Template '" + template.getName() + "' validation failed"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    protected void handleException(IOException x) {
        log.error((Object)x);
    }

    private static class CustomTemplatesStore
    extends SimplePreferenceStore {
        private static final String TEMPLATES_CONFIG_XML = "templates.xml";

        private CustomTemplatesStore() {
            super(DBWorkbench.getPlatform().getPreferenceStore());
            try {
                if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("public")) {
                    log.warn((Object)"The user has no permission to load sql templates configuration");
                    return;
                }
                String content = DBWorkbench.getPlatform().getProductConfigurationController().loadConfigurationFile(TEMPLATES_CONFIG_XML);
                if (CommonUtils.isNotEmpty((String)content)) {
                    this.setValue(SQLTemplateStore.PREF_STORE_KEY, content);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }

        public void save() throws IOException {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                log.warn((Object)"The user has no permission to save sql templates configuration");
                return;
            }
            String templatesConfig = this.getString(SQLTemplateStore.PREF_STORE_KEY);
            try {
                DBWorkbench.getPlatform().getProductConfigurationController().saveConfigurationFile(TEMPLATES_CONFIG_XML, templatesConfig);
            }
            catch (DBException e) {
                log.warn((Object)"Can't save template configuration", (Throwable)e);
            }
        }
    }
}

