/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.ConnectionTestJob;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionTestDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;

public abstract class ConnectionWizard
extends ActiveWizard
implements INewWizard {
    static final String PROP_CONNECTION_TYPE = "connection-type";
    private final Map<DriverDescriptor, DataSourceDescriptor> infoMap = new HashMap<DriverDescriptor, DataSourceDescriptor>();
    private final List<IPropertyChangeListener> propertyListeners = new ArrayList<IPropertyChangeListener>();

    protected ConnectionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        if (this.isNew()) {
            return CoreMessages.dialog_new_connection_wizard_title;
        }
        DataSourceDescriptor activeDataSource = this.getActiveDataSource();
        return NLS.bind((String)CoreMessages.dialog_connection_edit_title, (Object)activeDataSource.getName());
    }

    public Image getDefaultPageImage() {
        return super.getDefaultPageImage();
    }

    public void dispose() {
        for (DataSourceDescriptor dataSource : this.infoMap.values()) {
            dataSource.dispose();
        }
        super.dispose();
    }

    @Nullable
    public abstract DBPDataSourceRegistry getDataSourceRegistry();

    abstract DBPDriver getSelectedDriver();

    abstract DBPProject getSelectedProject();

    abstract DBNBrowseSettings getSelectedNavigatorSettings();

    public abstract ConnectionPageSettings getPageSettings();

    protected abstract void saveSettings(DataSourceDescriptor var1);

    @NotNull
    public DataSourceDescriptor getActiveDataSource() {
        DriverDescriptor driver = (DriverDescriptor)this.getSelectedDriver();
        DataSourceDescriptor info = this.infoMap.get(driver);
        DBPDataSourceRegistry registry = this.getDataSourceRegistry();
        if (registry == null) {
            throw new IllegalStateException("No active project");
        }
        if (info == null) {
            DBPConnectionConfiguration connectionInfo = this.getDefaultConnectionConfiguration();
            info = new DataSourceDescriptor(registry, DataSourceDescriptor.generateNewId((DBPDriver)driver), (DBPDriver)driver, connectionInfo);
            DBPNativeClientLocation defaultClientLocation = driver.getDefaultClientLocation();
            if (defaultClientLocation != null) {
                info.getConnectionConfiguration().setClientHomeId(defaultClientLocation.getName());
            }
            info.setSavePassword(true);
            this.infoMap.put(driver, info);
        }
        return info;
    }

    public DataSourceDescriptor getOriginalDataSource() {
        return null;
    }

    public void testConnection() {
        DataSourceDescriptor dataSource = this.getPageSettings().getActiveDataSource();
        DataSourceDescriptor testDataSource = new DataSourceDescriptor(dataSource, dataSource.getRegistry());
        this.saveSettings(testDataSource);
        testDataSource.setTemporary(true);
        testDataSource.setId(DataSourceDescriptor.generateNewId((DBPDriver)dataSource.getDriver()));
        testDataSource.getPreferenceStore().setValue("database.meta.separate.connection", ModelPreferences.SeparateConnectionBehavior.NEVER.name());
        try {
            ConnectionTestJob op = new ConnectionTestJob((DBPDataSourceContainer)testDataSource, session -> {
                IWizardPage[] iWizardPageArray = this.getPages();
                int n = iWizardPageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray[n2];
                    this.testInPage((DBCSession)session, (IDialogPage)page);
                    ++n2;
                }
            });
            try {
                this.getRunnableContext().run(true, true, monitor -> {
                    op.setOwnerMonitor(monitor);
                    op.schedule();
                    while (op.getState() == 2 || op.getState() == 4) {
                        if (monitor.isCanceled()) {
                            op.cancel();
                            throw new InterruptedException();
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    if (op.getConnectError() != null) {
                        throw new InvocationTargetException(op.getConnectError());
                    }
                    if (op.getConnectStatus() == Status.CANCEL_STATUS) {
                        throw new InterruptedException("cancel");
                    }
                });
                new ConnectionTestDialog(this.getShell(), dataSource, op.getServerVersion(), op.getClientVersion(), op.getConnectTime()).open();
            }
            catch (InterruptedException ex) {
                if (!"cancel".equals(ex.getMessage())) {
                    DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_interrupted_title, CoreMessages.dialog_connection_wizard_start_dialog_interrupted_message);
                }
            }
            catch (InvocationTargetException ex) {
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex.getTargetException()));
            }
            catch (Throwable ex) {
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex));
            }
        }
        finally {
            testDataSource.dispose();
        }
    }

    public boolean isNew() {
        return false;
    }

    private void testInPage(DBCSession session, IDialogPage page) {
        if (page instanceof IDataSourceConnectionTester && page.getControl() != null && !page.getControl().isDisposed()) {
            ((IDataSourceConnectionTester)page).testConnection(session);
        }
        if (page instanceof IDialogPageProvider && ConnectionWizard.isPageActive((IDialogPage)page)) {
            for (IDialogPage subPage : ArrayUtils.safeArray((Object[])((IDialogPageProvider)page).getDialogPages(false, false))) {
                this.testInPage(session, subPage);
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.add(listener);
    }

    public void firePropertyChangeEvent(String property, Object oldValue, Object newValue) {
        for (IPropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(new PropertyChangeEvent((Object)this, property, oldValue, newValue));
        }
    }

    public boolean openSettingsPage(String pageId) {
        IWizardPage page = this.getPage(pageId);
        if (page != null) {
            this.getContainer().showPage(page);
            return true;
        }
        return false;
    }

    @NotNull
    protected DBPConnectionConfiguration getDefaultConnectionConfiguration() {
        return new DBPConnectionConfiguration();
    }
}

