/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DefaultViewerToolTipSupport;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.registry.ConfirmationDescriptor;
import org.jkiss.dbeaver.ui.registry.ConfirmationRegistry;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageConfirmations
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.confirmations";
    private Table confirmTable;
    private List<ConfirmationWithStatus> confirmations = new ArrayList<ConfirmationWithStatus>();
    private Map<ConfirmationDescriptor, Object> changedConfirmations = new HashMap<ConfirmationDescriptor, Object>();

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        final TableViewer tableViewer = new TableViewer(composite, 68352);
        this.confirmTable = tableViewer.getTable();
        this.confirmTable.setLayoutData((Object)new GridData(1808));
        this.confirmTable.setHeaderVisible(true);
        this.confirmTable.setLinesVisible(true);
        ViewerColumnController columnsController = new ViewerColumnController("PrefPageConfirmationsEditor", (ColumnViewer)tableViewer);
        columnsController.addColumn(CoreMessages.pref_page_confirmations_table_column_confirmation, CoreMessages.pref_page_confirmations_table_column_confirmation_tip, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return ((ConfirmationWithStatus)element).confirmation.getDescription();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return ((ConfirmationWithStatus)element).confirmation.getTitle();
                }
                return super.getText(element);
            }
        });
        columnsController.addBooleanColumn(CoreMessages.pref_page_confirmations_table_column_value, CoreMessages.pref_page_confirmations_table_column_value_tip, 0x1000000, true, true, item -> {
            if (item instanceof ConfirmationWithStatus) {
                return ((ConfirmationWithStatus)item).enabled;
            }
            return false;
        }, new EditingSupport((ColumnViewer)tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return ((ConfirmationWithStatus)element).enabled;
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof ConfirmationWithStatus) {
                    ConfirmationWithStatus confirmation = (ConfirmationWithStatus)element;
                    confirmation.enabled = CommonUtils.getBoolean((Object)value, (boolean)true);
                    PrefPageConfirmations.this.changedConfirmations.put(confirmation.confirmation, value);
                }
            }
        });
        columnsController.addColumn(CoreMessages.pref_page_confirmations_table_column_group, CoreMessages.pref_page_confirmations_table_column_group, 131072, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ConfirmationWithStatus) {
                    return ((ConfirmationWithStatus)element).confirmation.getGroup();
                }
                return super.getText(element);
            }
        });
        columnsController.createColumns(false);
        tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        new DefaultViewerToolTipSupport((ColumnViewer)tableViewer);
        Collection descriptors = ConfirmationRegistry.getInstance().getConfirmations().stream().filter(item -> CommonUtils.isNotEmpty((String)item.getToggleMessage())).sorted(Comparator.comparing(ConfirmationDescriptor::getGroup)).collect(Collectors.toList());
        for (ConfirmationDescriptor confirmation : descriptors) {
            this.confirmations.add(new ConfirmationWithStatus(confirmation, this.getCurrentConfirmValue(confirmation.getId())));
        }
        tableViewer.setInput(this.confirmations);
        tableViewer.refresh();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.confirmTable, (boolean)true));
        return composite;
    }

    /*
     * Exception decompiling
     */
    private Boolean getCurrentConfirmValue(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl31 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl31 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        for (Map.Entry<ConfirmationDescriptor, Object> entry : this.changedConfirmations.entrySet()) {
            String id = entry.getKey().getId();
            store.setValue("org.jkiss.dbeaver.core.confirm." + id, entry.getValue().toString());
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    protected void performDefaults() {
        for (ConfirmationWithStatus confirmation : this.confirmations) {
            if (confirmation.enabled) continue;
            confirmation.enabled = true;
            this.changedConfirmations.put(confirmation.confirmation, Boolean.TRUE);
        }
        super.performDefaults();
    }

    private class ConfirmationWithStatus {
        private ConfirmationDescriptor confirmation;
        private boolean enabled;

        ConfirmationWithStatus(ConfirmationDescriptor confirmation, boolean enabled) {
            this.confirmation = confirmation;
            this.enabled = enabled;
        }
    }
}

