/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionNameResolver;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageGeneral;
import org.jkiss.dbeaver.ui.dialogs.connection.NavigatorSettingsStorage;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageConnectionsGeneral
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage,
NavigatorSettingsStorage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.connections";
    private static final String VALUE_TRUST_STRORE_TYPE_WINDOWS = "WINDOWS-ROOT";
    private CSmartCombo<DBPConnectionType> connectionTypeCombo;
    private Combo navigatorSettingsCombo;
    private Text connectionDefaultNamePatternText;
    private String connectionNamePattern;
    private DBPConnectionType defaultConnectionType;
    private DBNBrowseSettings defaultNavigatorSettings;
    private Text sampleConnectionName;
    private ConnectionNameResolver fakeConnectionNameResolver;
    private Button useWinTrustStoreCheck;

    public PrefPageConnectionsGeneral() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
        this.connectionNamePattern = ModelPreferences.getPreferences().getString("navigator.settings.default.connectionPattern");
        this.defaultNavigatorSettings = DataSourceNavigatorSettings.PRESET_FULL.getSettings();
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group groupDefaults = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_connection_label_default_settings, (int)1, (int)2, (int)0);
        Composite groupComposite = UIUtils.createComposite((Composite)groupDefaults, (int)2);
        this.connectionTypeCombo = ConnectionPageGeneral.createConnectionTypeCombo(groupComposite);
        this.connectionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionsGeneral.this.defaultConnectionType = (DBPConnectionType)PrefPageConnectionsGeneral.this.connectionTypeCombo.getSelectedItem();
            }
        });
        this.navigatorSettingsCombo = ConnectionPageGeneral.createNavigatorSettingsCombo(groupComposite, this, null);
        this.connectionDefaultNamePatternText = UIUtils.createLabelText((Composite)groupComposite, (String)CoreMessages.pref_page_connection_label_default_connection_name_pattern, (String)CoreMessages.pref_page_connection_label_default_connection_name_pattern_tip);
        ContentAssistUtils.installContentProposal((Control)this.connectionDefaultNamePatternText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider((String[])Arrays.stream(ConnectionNameResolver.getConnectionVariables()).map(GeneralUtils::variablePattern).toArray(String[]::new)));
        this.connectionDefaultNamePatternText.setText(this.connectionNamePattern);
        UIUtils.setContentProposalToolTip((Control)this.connectionDefaultNamePatternText, (String)"Connection name patterns", (String[])ConnectionNameResolver.getConnectionVariables());
        this.fakeConnectionNameResolver = this.generateSampleDatasourceResolver();
        this.sampleConnectionName = UIUtils.createLabelText((Composite)groupComposite, (String)CoreMessages.pref_page_connection_label_default_connection_name_pattern_sample, (String)CoreMessages.pref_page_connection_label_default_connection_name_pattern_sample_tip);
        this.sampleConnectionName.setEditable(false);
        this.sampleConnectionName.setText(GeneralUtils.replaceVariables((String)this.connectionDefaultNamePatternText.getText(), (IVariableResolver)this.fakeConnectionNameResolver));
        this.connectionDefaultNamePatternText.addModifyListener(e -> this.sampleConnectionName.setText(GeneralUtils.replaceVariables((String)this.connectionDefaultNamePatternText.getText(), (IVariableResolver)this.fakeConnectionNameResolver)));
        new VariablesHintLabel((Composite)groupDefaults, CoreMessages.pref_page_connection_label_default_connection_template_variables, CoreMessages.pref_page_connection_label_default_connection_template_variables_tip, ConnectionNameResolver.getConnectionVariablesInfo(), false);
        if (RuntimeUtils.isWindows()) {
            Group settings = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_connections_group_security, (int)2, (int)768, (int)300);
            if (CommonUtils.isNotEmpty((String)System.getProperty("javax.net.ssl.trustStore")) || CommonUtils.isNotEmpty((String)System.getProperty("javax.net.ssl.trustStoreType")) && !System.getProperty("javax.net.ssl.trustStoreType").equalsIgnoreCase(VALUE_TRUST_STRORE_TYPE_WINDOWS)) {
                Composite winTrustStoreComposite = UIUtils.createComposite((Composite)settings, (int)1);
                this.useWinTrustStoreCheck = UIUtils.createCheckbox((Composite)winTrustStoreComposite, (String)CoreMessages.pref_page_connections_use_win_cert_label, (boolean)ModelPreferences.getPreferences().getBoolean("connections.useWinTrustStoreType"));
                winTrustStoreComposite.setToolTipText(CoreMessages.pref_page_connections_use_win_cert_disabled_tip);
                this.useWinTrustStoreCheck.setEnabled(false);
            } else {
                this.useWinTrustStoreCheck = UIUtils.createCheckbox((Composite)settings, (String)CoreMessages.pref_page_connections_use_win_cert_label, (boolean)ModelPreferences.getPreferences().getBoolean("connections.useWinTrustStoreType"));
                this.useWinTrustStoreCheck.setToolTipText(CoreMessages.pref_page_connections_use_win_cert_tip);
            }
        }
        Group groupObjects = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_eclipse_ui_general_group_general, (int)1, (int)2, (int)0);
        Label descLabel = new Label((Composite)groupObjects, 64);
        descLabel.setText(CoreMessages.pref_page_eclipse_ui_general_connections_group_label);
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.drivers");
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.main.errorHandle");
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.main.meta");
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.main.transactions");
        this.updateCombosAndSettings();
        return composite;
    }

    public void init(IWorkbench iWorkbench) {
    }

    private ConnectionNameResolver generateSampleDatasourceResolver() {
        DataSourceRegistry dataSourceRegistry = new DataSourceRegistry(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        DBPDriver driver = (DBPDriver)DriverUtils.getRecentDrivers((List)DriverUtils.getAllDrivers(), (int)1).get(0);
        DBPConnectionConfiguration conConfig = new DBPConnectionConfiguration();
        conConfig.setHostName("hostname");
        conConfig.setUserPassword("password1");
        conConfig.setDatabaseName("database1");
        conConfig.setHostPort("42");
        conConfig.setServerName("server1");
        conConfig.setUrl("sample//url");
        DataSourceDescriptor fakeDataSource = new DataSourceDescriptor((DBPDataSourceRegistry)dataSourceRegistry, DataSourceDescriptor.generateNewId((DBPDriver)driver), driver, conConfig);
        dataSourceRegistry.dispose();
        return new ConnectionNameResolver((DBPDataSourceContainer)fakeDataSource, conConfig, null);
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable iAdaptable) {
    }

    private void addLinkToSettings(Composite composite, String pageID) {
        new PreferenceLinkArea(composite, 0, pageID, "<a>''{0}''</a> " + CoreMessages.pref_page_ui_general_label_settings, (IWorkbenchPreferenceContainer)this.getContainer(), null);
    }

    @Override
    public DBNBrowseSettings getNavigatorSettings() {
        return this.defaultNavigatorSettings;
    }

    @Override
    public void setNavigatorSettings(DBNBrowseSettings settings) {
        this.defaultNavigatorSettings = settings;
    }

    protected void performDefaults() {
        this.connectionDefaultNamePatternText.setText(ModelPreferences.getPreferences().getDefaultString("navigator.settings.default.connectionPattern"));
        this.sampleConnectionName.setText(GeneralUtils.replaceVariables((String)this.connectionDefaultNamePatternText.getText(), (IVariableResolver)this.fakeConnectionNameResolver));
        this.connectionNamePattern = ModelPreferences.getPreferences().getDefaultString("navigator.settings.default.connectionPattern");
        if (RuntimeUtils.isWindows()) {
            this.useWinTrustStoreCheck.setSelection(ModelPreferences.getPreferences().getDefaultBoolean("connections.useWinTrustStoreType"));
        }
        this.updateCombosAndSettings();
    }

    private void updateCombosAndSettings() {
        this.defaultConnectionType = DBPConnectionType.getDefaultConnectionType();
        int i = 0;
        while (i < this.connectionTypeCombo.getItemCount()) {
            if (((DBPConnectionType)this.connectionTypeCombo.getItem(i)).getId().equals(this.defaultConnectionType.getId())) {
                this.connectionTypeCombo.select(i);
                break;
            }
            ++i;
        }
        this.defaultNavigatorSettings = DataSourceNavigatorSettings.getDefaultSettings();
        ConnectionPageGeneral.updateNavigatorSettingsPreset(this.navigatorSettingsCombo, this.defaultNavigatorSettings);
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.defaultConnectionType != DBPConnectionType.getDefaultConnectionType()) {
            DBPConnectionType.setDefaultConnectionType((DBPConnectionType)this.defaultConnectionType);
        }
        if (!this.defaultNavigatorSettings.equals(DataSourceNavigatorSettings.getDefaultSettings())) {
            DataSourceNavigatorSettings.setDefaultSettings((DBNBrowseSettings)this.defaultNavigatorSettings);
        }
        ModelPreferences.getPreferences().setValue("navigator.settings.default.connectionPattern", this.connectionDefaultNamePatternText.getText());
        if (RuntimeUtils.isWindows()) {
            ModelPreferences.getPreferences().setValue("connections.useWinTrustStoreType", this.useWinTrustStoreCheck.getSelection());
        }
        return super.performOk();
    }
}

