/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDInsertReplaceMethod;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.utils.CommonUtils;

public class PostgreInsertReplaceMethod
implements DBDInsertReplaceMethod {
    private static final Log log = Log.getLog(PostgreInsertReplaceMethod.class);

    @NotNull
    public String getOpeningClause(DBSTable table, DBRProgressMonitor monitor) {
        return "INSERT INTO";
    }

    public String getTrailingClause(DBSTable table, DBRProgressMonitor monitor, DBSAttributeBase[] attributes) {
        StringBuilder query = new StringBuilder();
        try {
            String onConflictExpression = "ON CONFLICT (%s) DO UPDATE SET %s";
            Collection constraints = table.getConstraints(monitor);
            if (!CommonUtils.isEmpty((Collection)constraints)) {
                DBSTableConstraint dbsTableConstraint;
                List attributeReferences;
                StringBuilder pkNames = new StringBuilder();
                Optional<DBSTableConstraint> tableConstraint = constraints.stream().filter(key -> key.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY).findFirst();
                if (tableConstraint.isPresent() && !CommonUtils.isEmpty((Collection)(attributeReferences = (dbsTableConstraint = tableConstraint.get()).getAttributeReferences(monitor)))) {
                    boolean hasKey = false;
                    for (DBSEntityAttributeRef column : attributeReferences) {
                        DBSEntityAttribute attribute;
                        if (hasKey) {
                            pkNames.append(",");
                        }
                        if ((attribute = column.getAttribute()) == null) continue;
                        pkNames.append(DBUtils.getQuotedIdentifier((DBSObject)attribute));
                        hasKey = true;
                    }
                    StringBuilder updateExpression = new StringBuilder();
                    updateExpression.append("(");
                    this.addAttributesNamesList(table, attributes, false, updateExpression);
                    updateExpression.append(") = (");
                    this.addAttributesNamesList(table, attributes, true, updateExpression);
                    updateExpression.append(")");
                    query.append(" ").append(String.format(onConflictExpression, pkNames, updateExpression));
                }
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't read table constraints list", (Throwable)e);
        }
        return query.toString();
    }

    private void addAttributesNamesList(DBSTable table, DBSAttributeBase[] attributes, boolean isExcluded, StringBuilder updateExpression) {
        boolean hasKey = false;
        DBSAttributeBase[] dBSAttributeBaseArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSAttributeBase attribute = dBSAttributeBaseArray[n2];
            if (!DBUtils.isPseudoAttribute((DBSAttributeBase)attribute)) {
                if (hasKey) {
                    updateExpression.append(",");
                }
                hasKey = true;
                if (isExcluded) {
                    updateExpression.append("EXCLUDED.");
                }
                updateExpression.append(this.getAttributeName(table, attribute));
            }
            ++n2;
        }
    }

    private String getAttributeName(DBSTable table, @NotNull DBSAttributeBase attribute) {
        return DBUtils.isPseudoAttribute((DBSAttributeBase)attribute) ? attribute.getName() : DBUtils.getObjectFullName((DBPDataSource)table.getDataSource(), (DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }
}

