/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2DeleteUpdateRule;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.CommonUtils;

public class DB2TableForeignKey
extends JDBCTableConstraint<DB2Table>
implements DBSTableForeignKey {
    private static final Log log = Log.getLog(DB2TableForeignKey.class);
    private DB2Table refTable;
    private DB2DeleteUpdateRule db2DeleteRule;
    private DB2DeleteUpdateRule db2UpdateRule;
    private List<DB2TableKeyColumn> columns;
    private DB2TableUniqueKey referencedKey;

    public DB2TableForeignKey(DBRProgressMonitor monitor, DB2Table db2Table, ResultSet dbResult) throws DBException {
        super((JDBCTable)db2Table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTNAME"), null, DBSEntityConstraintType.FOREIGN_KEY, true);
        String refSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"REFTABSCHEMA");
        String refTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFTABNAME");
        String constName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFKEYNAME");
        this.refTable = DB2Utils.findTableBySchemaNameAndName(monitor, (DB2DataSource)db2Table.getDataSource(), refSchemaName, refTableName);
        if (this.refTable != null) {
            this.referencedKey = this.refTable.getConstraint(monitor, constName);
        } else {
            log.warn((Object)("Referenced table '" + DBUtils.getSimpleQualifiedName((Object[])new Object[]{refSchemaName, refTableName}) + "' not found"));
        }
        this.db2DeleteRule = (DB2DeleteUpdateRule)CommonUtils.valueOf(DB2DeleteUpdateRule.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DELETERULE"));
        this.db2UpdateRule = (DB2DeleteUpdateRule)CommonUtils.valueOf(DB2DeleteUpdateRule.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"UPDATERULE"));
    }

    public DB2TableForeignKey(DB2Table db2Table, DB2TableUniqueKey referencedKey, DBSForeignKeyModifyRule deleteRule, DBSForeignKeyModifyRule updateRule) {
        super((JDBCTable)db2Table, null, null, DBSEntityConstraintType.FOREIGN_KEY, true);
        this.referencedKey = referencedKey;
        this.db2DeleteRule = DB2DeleteUpdateRule.getDB2RuleFromDBSRule(deleteRule);
        this.db2UpdateRule = DB2DeleteUpdateRule.getDB2RuleFromDBSRule(updateRule);
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return ((DB2Table)this.getTable()).getDataSource();
    }

    public DB2Table getAssociatedEntity() {
        return this.refTable;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((DB2Table)this.getTable()).getContainer(), this.getTable(), this});
    }

    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return this.db2UpdateRule.getRule();
    }

    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return this.db2DeleteRule.getRule();
    }

    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    public void setColumns(List<DB2TableKeyColumn> columns) {
        this.columns = columns;
    }

    @Property(viewable=true, order=3)
    public DB2Table getReferencedTable() {
        return this.refTable;
    }

    @Property(id="reference", viewable=false)
    @Nullable
    public DB2TableUniqueKey getReferencedConstraint() {
        return this.referencedKey;
    }

    public void setReferencedConstraint(DB2TableUniqueKey referencedKey) {
        this.referencedKey = referencedKey;
    }

    @Property(viewable=true, editable=true)
    public DB2DeleteUpdateRule getDb2DeleteRule() {
        return this.db2DeleteRule;
    }

    public void setDb2DeleteRule(DB2DeleteUpdateRule db2DeleteRule) {
        this.db2DeleteRule = db2DeleteRule;
    }

    @Property(viewable=true, editable=true)
    public DB2DeleteUpdateRule getDb2UpdateRule() {
        return this.db2UpdateRule;
    }

    public void setDb2UpdateRule(DB2DeleteUpdateRule db2UpdateRule) {
        this.db2UpdateRule = db2UpdateRule;
    }
}

