/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class SQLQueryParameterRegistry {
    private static final Log log = Log.getLog(SQLQueryParameterRegistry.class);
    public static final String CONFIG_FILE_NAME = "parameter-bindings.xml";
    public static final String TAG_PARAMETER = "parameter";
    private static SQLQueryParameterRegistry registry;
    private final Map<String, ParameterInfo> parameterMap = new LinkedHashMap<String, ParameterInfo>();

    private SQLQueryParameterRegistry() {
    }

    public static synchronized SQLQueryParameterRegistry getInstance() {
        if (registry == null) {
            registry = new SQLQueryParameterRegistry();
            registry.loadProfiles();
        }
        return registry;
    }

    public ParameterInfo getParameter(String name) {
        return this.parameterMap.get(name.toUpperCase(Locale.ENGLISH));
    }

    public void setParameter(String name, String value) {
        this.parameterMap.put(name.toUpperCase(Locale.ENGLISH), new ParameterInfo(name, value));
    }

    private void loadProfiles() {
        File storeFile = DBWorkbench.getPlatform().getConfigurationFile(CONFIG_FILE_NAME);
        if (!storeFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileInputStream is = new FileInputStream(storeFile);){
                SAXReader parser = new SAXReader((InputStream)is);
                try {
                    parser.parse((SAXListener)new ParametersParser());
                }
                catch (XMLException ex) {
                    throw new DBException("Parameters binding parse error", (Throwable)ex);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException ex) {
            log.warn((Object)("Can't load parameters binding from " + storeFile.getPath()), (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn((Object)"IO error", (Throwable)ex);
        }
    }

    public void save() {
        File storeFile = DBWorkbench.getPlatform().getConfigurationFile(CONFIG_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream os = new FileOutputStream(storeFile);){
                XMLBuilder xml = new XMLBuilder((OutputStream)os, GeneralUtils.UTF8_ENCODING);
                xml.setButify(true);
                xml.startElement("bindings");
                for (ParameterInfo param : this.parameterMap.values()) {
                    xml.startElement(TAG_PARAMETER);
                    xml.addAttribute("name", param.name);
                    xml.addAttribute("value", param.value);
                    xml.endElement();
                }
                xml.endElement();
                xml.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.warn((Object)"IO error", (Throwable)ex);
        }
    }

    public static class ParameterInfo {
        public String name;
        public String value;

        public ParameterInfo(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private class ParametersParser
    implements SAXListener {
        private String curParameterName;
        private String curParameterValue;
        private StringBuilder legacyParameterValue = new StringBuilder();

        private ParametersParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            if (localName.equals(SQLQueryParameterRegistry.TAG_PARAMETER)) {
                this.curParameterName = atts.getValue("name");
                this.curParameterValue = atts.getValue("value");
            }
        }

        public void saxText(SAXReader reader, String data) throws XMLException {
            if (this.curParameterName != null) {
                this.legacyParameterValue.append(data);
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
            if (localName.equals(SQLQueryParameterRegistry.TAG_PARAMETER) && this.curParameterName != null) {
                if (this.curParameterValue == null) {
                    String legacyValue = this.legacyParameterValue.toString().trim();
                    if (!legacyValue.isEmpty() && Character.isLetter(legacyValue.charAt(0))) {
                        legacyValue = "'" + legacyValue + "'";
                    }
                    this.curParameterValue = legacyValue;
                }
                SQLQueryParameterRegistry.this.parameterMap.put(this.curParameterName.toUpperCase(), new ParameterInfo(this.curParameterName, this.curParameterValue));
                this.curParameterName = null;
                this.legacyParameterValue.setLength(0);
            }
        }
    }
}

