/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.WindowsRegistry;

class WinRegistry11
extends WindowsRegistry {
    private static final Log log = Log.getLog(WinRegistry11.class);
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Long.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Long.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Long.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Long.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Long.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Long.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Long.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Long.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception e) {
            log.error("Error initializing Windows registry", e);
        }
    }

    WinRegistry11() {
    }

    @Override
    public String readString(long hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            return this.readString(systemRoot, hkey, key, valueName);
        }
        if (hkey == (long)HKEY_CURRENT_USER) {
            return this.readString(userRoot, hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    @Override
    public Map<String, String> readStringValues(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            return this.readStringValues(systemRoot, hkey, key);
        }
        if (hkey == (long)HKEY_CURRENT_USER) {
            return this.readStringValues(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    @Override
    public List<String> readStringSubKeys(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            return this.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == (long)HKEY_CURRENT_USER) {
            return this.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    @Override
    public void createKey(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] ret;
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            ret = this.createKey(systemRoot, hkey, key);
            regCloseKey.invoke((Object)systemRoot, ret[0]);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            ret = this.createKey(userRoot, hkey, key);
            regCloseKey.invoke((Object)userRoot, ret[0]);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        if (ret[1] != (long)REG_SUCCESS) {
            throw new IllegalArgumentException("rc=" + ret[1] + "  key=" + key);
        }
    }

    @Override
    public void writeStringValue(long hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            this.writeStringValue(systemRoot, hkey, key, valueName, value);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            this.writeStringValue(userRoot, hkey, key, valueName, value);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
    }

    @Override
    public void deleteKey(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            rc = this.deleteKey(systemRoot, hkey, key);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            rc = this.deleteKey(userRoot, hkey, key);
        }
        if (rc != REG_SUCCESS) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    @Override
    public void deleteValue(long hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long rc = -1L;
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            rc = this.deleteValue(systemRoot, hkey, key, value);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            rc = this.deleteValue(userRoot, hkey, key, value);
        }
        if (rc != (long)REG_SUCCESS) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private long deleteValue(Preferences root, long hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = (long[])regOpenKey.invoke(null, hkey, this.toCstr(key), 983103);
        if (handles[1] != (long)REG_SUCCESS) {
            return handles[1];
        }
        int rc = (Integer)regDeleteValue.invoke(null, handles[0], this.toCstr(value));
        regCloseKey.invoke(null, handles[0]);
        return rc;
    }

    private int deleteKey(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Integer)regDeleteKey.invoke(null, hkey, this.toCstr(key));
    }

    private String readString(Preferences root, long hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = (long[])regOpenKey.invoke(null, hkey, this.toCstr(key), 131097);
        if (handles[1] != (long)REG_SUCCESS) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke(null, handles[0], this.toCstr(value));
        regCloseKey.invoke(null, handles[0]);
        return valb != null ? new String(valb).trim() : null;
    }

    private Map<String, String> readStringValues(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        long[] handles = (long[])regOpenKey.invoke(null, hkey, this.toCstr(key), 131097);
        if (handles[1] != (long)REG_SUCCESS) {
            return null;
        }
        long[] info = (long[])regQueryInfoKey.invoke(null, handles[0]);
        long count = info[2];
        int maxlen = 256;
        int index = 0;
        while ((long)index < count) {
            byte[] name = (byte[])regEnumValue.invoke(null, handles[0], index, maxlen + 1);
            if (name != null) {
                String value = this.readString(hkey, key, new String(name));
                results.put(new String(name).trim(), value);
            }
            ++index;
        }
        regCloseKey.invoke(null, handles[0]);
        return results;
    }

    private List<String> readStringSubKeys(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        long[] handles = (long[])regOpenKey.invoke(null, hkey, this.toCstr(key), 131097);
        if (handles[1] != (long)REG_SUCCESS) {
            return null;
        }
        long[] info = (long[])regQueryInfoKey.invoke(null, handles[0]);
        long cfr_ignored_0 = info[2];
        int maxlen = (int)info[3];
        int index = 0;
        while (index < Integer.MAX_VALUE) {
            byte[] name = (byte[])regEnumKeyEx.invoke(null, handles[0], index, maxlen + 1);
            if (name == null) break;
            results.add(new String(name).trim());
            ++index;
        }
        regCloseKey.invoke(null, handles[0]);
        return results;
    }

    private long[] createKey(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (long[])regCreateKeyEx.invoke(null, hkey, this.toCstr(key));
    }

    private void writeStringValue(Preferences root, long hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = (long[])regOpenKey.invoke(null, hkey, this.toCstr(key), 983103);
        regSetValueEx.invoke(null, handles[0], this.toCstr(valueName), this.toCstr(value));
        regCloseKey.invoke(null, handles[0]);
    }

    public static void main(String[] args) throws InvocationTargetException, IllegalAccessException {
        System.out.println(System.getProperty("os.name"));
        WinRegistry11 winRegistry11 = new WinRegistry11();
        System.out.println(winRegistry11.readString(HKEY_LOCAL_MACHINE, "SOFTWARE\\ORACLE", "VOBHOME2.0"));
        System.out.println(winRegistry11.readStringSubKeys(HKEY_LOCAL_MACHINE, "SOFTWARE\\ORACLE"));
        System.out.println(winRegistry11.readStringValues(HKEY_LOCAL_MACHINE, "SOFTWARE\\ORACLE\\KEY_OraClient10g_home1"));
    }
}

