/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.views;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionRole;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.ext.oracle.oci.OracleHomeDescriptor;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIActivator;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.ext.oracle.ui.views.OracleConnectionExtraPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class OracleConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private Text hostText;
    private Text portText;
    private Combo sidServiceCombo;
    private Combo serviceNameCombo;
    private Text userNameText;
    private Combo userRoleCombo;
    private Text passwordText;
    private Combo tnsNameCombo;
    private TabFolder connectionTypeFolder;
    private ClientHomesSelector oraHomeSelector;
    private Text connectionUrlText;
    private Button osAuthCheck;
    private ControlsListener controlModifyListener;
    private OracleConstants.ConnectionType connectionType = OracleConstants.ConnectionType.BASIC;
    private static ImageDescriptor logoImage = OracleUIActivator.getImageDescriptor("icons/oracle_logo.png");
    private TextWithOpenFolder tnsPathText;
    private boolean activated = false;

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        super.setImageDescriptor(logoImage);
        this.controlModifyListener = new ControlsListener();
        Composite addrGroup = new Composite(composite, 0);
        addrGroup.setLayout((Layout)new GridLayout(1, false));
        addrGroup.setLayoutData((Object)new GridData(1808));
        Group protocolGroup = UIUtils.createControlGroup((Composite)addrGroup, (String)OracleUIMessages.dialog_connection_connection_type_group, (int)1, (int)768, (int)0);
        this.connectionTypeFolder = new TabFolder((Composite)protocolGroup, 130);
        this.connectionTypeFolder.setLayoutData((Object)new GridData(768));
        this.createBasicConnectionControls(this.connectionTypeFolder);
        this.createTNSConnectionControls(this.connectionTypeFolder);
        this.createCustomConnectionControls(this.connectionTypeFolder);
        this.connectionTypeFolder.setSelection(this.connectionType.ordinal());
        this.connectionTypeFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OracleConnectionPage.this.connectionType = (OracleConstants.ConnectionType)OracleConnectionPage.this.connectionTypeFolder.getSelection()[0].getData();
                OracleConnectionPage.this.site.getActiveDataSource().getConnectionConfiguration().setProviderProperty("@dbeaver-connection-type@", OracleConnectionPage.this.connectionType.name());
                OracleConnectionPage.this.updateUI();
            }
        });
        Group securityGroup = UIUtils.createControlGroup((Composite)addrGroup, (String)OracleUIMessages.dialog_connection_security_group, (int)4, (int)768, (int)0);
        this.createSecurityGroup((Composite)securityGroup);
        Composite bottomControls = UIUtils.createPlaceholder((Composite)addrGroup, (int)3);
        bottomControls.setLayoutData((Object)new GridData(768));
        this.createClientHomeGroup(bottomControls);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    private void createBasicConnectionControls(TabFolder protocolFolder) {
        TabItem protocolTabBasic = new TabItem(protocolFolder, 0);
        protocolTabBasic.setText(OracleUIMessages.dialog_connection_basic_tab);
        protocolTabBasic.setData((Object)OracleConstants.ConnectionType.BASIC);
        Composite targetContainer = new Composite((Composite)protocolFolder, 0);
        targetContainer.setLayout((Layout)new GridLayout(5, false));
        targetContainer.setLayoutData((Object)new GridData(768));
        protocolTabBasic.setControl((Control)targetContainer);
        Label hostLabel = UIUtils.createControlLabel((Composite)targetContainer, (String)OracleUIMessages.dialog_connection_host);
        GridData gd = new GridData(128);
        hostLabel.setLayoutData((Object)gd);
        this.hostText = new Text(targetContainer, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener((ModifyListener)this.controlModifyListener);
        UIUtils.createControlLabel((Composite)targetContainer, (String)OracleUIMessages.dialog_connection_port);
        this.portText = new Text(targetContainer, 2048);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 5;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener((ModifyListener)this.controlModifyListener);
        UIUtils.createControlLabel((Composite)targetContainer, (String)OracleUIMessages.dialog_connection_database);
        this.serviceNameCombo = new Combo(targetContainer, 4);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.serviceNameCombo.setLayoutData((Object)gd);
        this.serviceNameCombo.addModifyListener((ModifyListener)this.controlModifyListener);
        this.sidServiceCombo = new Combo(targetContainer, 12);
        this.sidServiceCombo.add(OracleConnectionType.SID.getTitle());
        this.sidServiceCombo.add(OracleConnectionType.SERVICE.getTitle());
        this.sidServiceCombo.select(1);
        this.sidServiceCombo.addModifyListener((ModifyListener)this.controlModifyListener);
    }

    private void createTNSConnectionControls(TabFolder protocolFolder) {
        TabItem protocolTabTNS = new TabItem(protocolFolder, 0);
        protocolTabTNS.setText(OracleUIMessages.dialog_connection_tns_tab);
        protocolTabTNS.setData((Object)OracleConstants.ConnectionType.TNS);
        Composite targetContainer = new Composite((Composite)protocolFolder, 0);
        targetContainer.setLayout((Layout)new GridLayout(2, false));
        targetContainer.setLayoutData((Object)new GridData(768));
        protocolTabTNS.setControl((Control)targetContainer);
        UIUtils.createControlLabel((Composite)targetContainer, (String)"Network Alias");
        this.tnsNameCombo = new Combo(targetContainer, 4);
        this.tnsNameCombo.setLayoutData((Object)new GridData(768));
        this.tnsNameCombo.addModifyListener((ModifyListener)this.controlModifyListener);
        UIUtils.createControlLabel((Composite)targetContainer, (String)"TNS names path");
        this.tnsPathText = new TextWithOpenFolder(targetContainer, "Oracle TNS names path");
        this.tnsPathText.setLayoutData((Object)new GridData(768));
        this.tnsPathText.setToolTipText("Path to TNSNAMES.ora file");
        this.tnsPathText.getTextControl().addModifyListener(e -> {
            this.populateTnsNameCombo();
            this.updateUI();
        });
    }

    private Collection<String> getAvailableServiceNames() {
        String tnsPath = this.tnsPathText.getText();
        if (!CommonUtils.isEmpty((String)tnsPath)) {
            File tnsFile = new File(tnsPath);
            if (tnsFile.exists()) {
                return OCIUtils.readTnsNames((File)tnsFile, (boolean)false).keySet();
            }
            return Collections.emptyList();
        }
        String oraHome = this.oraHomeSelector.getSelectedHome();
        if (CommonUtils.isEmpty((String)oraHome)) {
            return OCIUtils.readTnsNames(null, (boolean)true).keySet();
        }
        OracleHomeDescriptor home = OCIUtils.getOraHomeByName((String)oraHome);
        if (home != null) {
            return home.getOraServiceNames();
        }
        return OCIUtils.readTnsNames((File)new File(oraHome), (boolean)true).keySet();
    }

    private void populateTnsNameCombo() {
        String oldText = this.tnsNameCombo.getText();
        this.tnsNameCombo.removeAll();
        Collection<String> serviceNames = this.getAvailableServiceNames();
        if (serviceNames.isEmpty()) {
            this.tnsNameCombo.setEnabled(false);
        } else {
            this.tnsNameCombo.setEnabled(true);
            for (String alias : serviceNames) {
                this.tnsNameCombo.add(alias);
            }
            if (!oldText.isEmpty()) {
                UIUtils.setComboSelection((Combo)this.tnsNameCombo, (String)oldText);
            }
            if (this.tnsNameCombo.getSelectionIndex() < 0) {
                this.tnsNameCombo.select(0);
            }
        }
    }

    private void createCustomConnectionControls(TabFolder protocolFolder) {
        TabItem protocolTabCustom = new TabItem(protocolFolder, 0);
        protocolTabCustom.setText(OracleUIMessages.dialog_connection_custom_tab);
        protocolTabCustom.setData((Object)OracleConstants.ConnectionType.CUSTOM);
        Composite targetContainer = new Composite((Composite)protocolFolder, 0);
        targetContainer.setLayout((Layout)new GridLayout(2, false));
        targetContainer.setLayoutData((Object)new GridData(1808));
        protocolTabCustom.setControl((Control)targetContainer);
        Label urlLabel = UIUtils.createControlLabel((Composite)targetContainer, (String)"JDBC URL");
        urlLabel.setLayoutData((Object)new GridData(2));
        this.connectionUrlText = new Text(targetContainer, 2626);
        this.connectionUrlText.setLayoutData((Object)new GridData(1808));
        this.connectionUrlText.addModifyListener((ModifyListener)this.controlModifyListener);
    }

    private void createSecurityGroup(Composite parent) {
        Label userNameLabel = UIUtils.createControlLabel((Composite)parent, (String)OracleUIMessages.dialog_connection_user_name);
        userNameLabel.setLayoutData((Object)new GridData(128));
        this.userNameText = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.userNameText.setLayoutData((Object)gd);
        this.userNameText.addModifyListener((ModifyListener)this.controlModifyListener);
        Label userRoleLabel = UIUtils.createControlLabel((Composite)parent, (String)OracleUIMessages.dialog_connection_role);
        userRoleLabel.setLayoutData((Object)new GridData(128));
        this.userRoleCombo = new Combo(parent, 12);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.userRoleCombo) * 10;
        this.userRoleCombo.setLayoutData((Object)gd);
        this.userRoleCombo.add(OracleConnectionRole.NORMAL.getTitle());
        this.userRoleCombo.add(OracleConnectionRole.SYSDBA.getTitle());
        this.userRoleCombo.add(OracleConnectionRole.SYSOPER.getTitle());
        this.userRoleCombo.select(0);
        Label passwordLabel = UIUtils.createControlLabel((Composite)parent, (String)OracleUIMessages.dialog_connection_password);
        passwordLabel.setLayoutData((Object)new GridData(128));
        this.passwordText = new Text(parent, 0x400800);
        gd = new GridData(768);
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener((ModifyListener)this.controlModifyListener);
        this.osAuthCheck = UIUtils.createCheckbox((Composite)parent, (String)OracleUIMessages.dialog_connection_os_authentication, (boolean)false);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.osAuthCheck.setLayoutData((Object)gd);
        this.osAuthCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean osAuth = OracleConnectionPage.this.osAuthCheck.getSelection();
                OracleConnectionPage.this.userNameText.setEnabled(!osAuth);
                OracleConnectionPage.this.passwordText.setEnabled(!osAuth);
                OracleConnectionPage.this.savePasswordCheck.setEnabled(!osAuth);
            }
        });
        this.createPasswordControls(parent, this.passwordText, 4);
        parent.setTabList(new Control[]{this.userNameText, this.passwordText, this.userRoleCombo, this.osAuthCheck});
    }

    private void createClientHomeGroup(Composite bottomControls) {
        this.oraHomeSelector = new ClientHomesSelector(bottomControls, 0, OracleUIMessages.dialog_connection_ora_home){

            protected void handleHomeChange() {
                OracleConnectionPage.this.populateTnsNameCombo();
            }
        };
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)bottomControls) * 30;
        this.oraHomeSelector.getPanel().setLayoutData((Object)gd);
        Label ph = new Label(bottomControls, 0);
        ph.setLayoutData((Object)new GridData(768));
    }

    public boolean isComplete() {
        switch (this.connectionType) {
            case BASIC: {
                return !CommonUtils.isEmpty((String)this.serviceNameCombo.getText());
            }
            case TNS: {
                return !CommonUtils.isEmpty((String)this.tnsNameCombo.getText());
            }
            case CUSTOM: {
                return !CommonUtils.isEmpty((String)this.connectionUrlText.getText());
            }
        }
        return false;
    }

    protected boolean isCustomURL() {
        return this.connectionType == OracleConstants.ConnectionType.CUSTOM;
    }

    public void loadSettings() {
        String conTypeProperty;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String sidService = connectionInfo.getProviderProperty("@dbeaver-sid-service@");
        if (sidService != null) {
            this.sidServiceCombo.setText(OracleConnectionType.valueOf((String)sidService).getTitle());
        }
        this.oraHomeSelector.populateHomes(this.site.getDriver(), connectionInfo.getClientHomeId(), this.site.isNew());
        if (this.tnsNameCombo.getItemCount() == 0) {
            this.populateTnsNameCombo();
        }
        if (this.serviceNameCombo.getItemCount() == 0) {
            for (String alias : this.getAvailableServiceNames()) {
                this.serviceNameCombo.add(alias);
            }
        }
        this.connectionType = (conTypeProperty = connectionInfo.getProviderProperty("@dbeaver-connection-type@")) != null ? OracleConstants.ConnectionType.valueOf((String)CommonUtils.toString((Object)conTypeProperty)) : OracleConstants.ConnectionType.BASIC;
        this.connectionTypeFolder.setSelection(this.connectionType.ordinal());
        switch (this.connectionType) {
            case BASIC: {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
                } else if (this.site.getDriver().getDefaultPort() != null) {
                    this.portText.setText(this.site.getDriver().getDefaultPort());
                } else {
                    this.portText.setText("");
                }
                this.serviceNameCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
                break;
            }
            case TNS: {
                this.tnsNameCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
                String tnsPathProperty = connectionInfo.getProviderProperty("@dbeaver-tns-path@");
                if (tnsPathProperty == null) break;
                this.tnsPathText.setText(tnsPathProperty);
                break;
            }
            case CUSTOM: {
                this.connectionUrlText.setText(CommonUtils.notEmpty((String)connectionInfo.getUrl()));
            }
        }
        if (CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-os-authentication@"))) {
            this.userNameText.setEnabled(false);
            this.passwordText.setEnabled(false);
            this.savePasswordCheck.setEnabled(false);
            this.osAuthCheck.setSelection(true);
        } else {
            this.userNameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
            this.osAuthCheck.setSelection(false);
        }
        String roleName = connectionInfo.getProviderProperty("@dbeaver-internal-logon@");
        if (roleName != null) {
            this.userRoleCombo.setText(roleName.toUpperCase(Locale.ENGLISH));
        }
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setClientHomeId(this.oraHomeSelector.getSelectedHome());
        connectionInfo.setProviderProperty("@dbeaver-connection-type@", this.connectionType.name());
        switch (this.connectionType) {
            case BASIC: {
                connectionInfo.setHostName(this.hostText.getText().trim());
                connectionInfo.setHostPort(this.portText.getText().trim());
                connectionInfo.setDatabaseName(this.serviceNameCombo.getText().trim());
                break;
            }
            case TNS: {
                connectionInfo.setDatabaseName(this.tnsNameCombo.getText().trim());
                connectionInfo.setProviderProperty("@dbeaver-tns-path@", this.tnsPathText.getText());
                break;
            }
            case CUSTOM: {
                connectionInfo.setUrl(this.connectionUrlText.getText());
            }
        }
        if (this.osAuthCheck.getSelection()) {
            connectionInfo.setUserName("");
            connectionInfo.setUserPassword("");
            connectionInfo.setProviderProperty("@dbeaver-os-authentication@", String.valueOf(true));
        } else {
            connectionInfo.setUserName(this.userNameText.getText());
            connectionInfo.setUserPassword(this.passwordText.getText());
            connectionInfo.removeProviderProperty("@dbeaver-os-authentication@");
        }
        connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.getTypeForTitle((String)this.sidServiceCombo.getText()).name());
        if (this.userRoleCombo.getSelectionIndex() > 0) {
            connectionInfo.setProviderProperty("@dbeaver-internal-logon@", this.userRoleCombo.getText().toLowerCase(Locale.ENGLISH));
        } else {
            connectionInfo.getProviderProperties().remove("@dbeaver-internal-logon@");
        }
        super.saveSettings(dataSource);
    }

    private void updateUI() {
        if (this.activated) {
            this.site.updateButtons();
        }
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[]{new OracleConnectionExtraPage(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    private class ControlsListener
    implements ModifyListener,
    SelectionListener {
        private ControlsListener() {
        }

        public void modifyText(ModifyEvent e) {
            OracleConnectionPage.this.updateUI();
        }

        public void widgetSelected(SelectionEvent e) {
            OracleConnectionPage.this.updateUI();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            OracleConnectionPage.this.updateUI();
        }
    }
}

