/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreRoleMember
implements DBSObject {
    private final PostgreRole owner;
    private long role;
    private long member;
    private long grantor;
    private boolean adminOption;

    public PostgreRoleMember(PostgreRole owner, ResultSet dbResult) throws SQLException {
        this.owner = owner;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.role = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"roleid");
        this.member = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"member");
        this.grantor = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"grantor");
        this.adminOption = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"admin_option");
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.owner;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this.owner.getDataSource();
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getName() {
        return String.valueOf(this.member);
    }

    @Property(viewable=true, order=1)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.owner.getDatabase().getRoleById(monitor, this.role);
    }

    @Property(viewable=true, order=2)
    public PostgreRole getMember(DBRProgressMonitor monitor) throws DBException {
        return this.owner.getDatabase().getRoleById(monitor, this.member);
    }

    @Property(viewable=true, order=3)
    public PostgreRole getGrantor(DBRProgressMonitor monitor) throws DBException {
        return this.owner.getDatabase().getRoleById(monitor, this.grantor);
    }

    @Property(viewable=true, order=4)
    public boolean isAdminOption() {
        return this.adminOption;
    }

    public String toString() {
        return this.getName();
    }
}

