/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.fdw;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class FDWConfigDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(FDWConfigDescriptor.class);
    @NotNull
    private final String id;
    @NotNull
    private final String fdwId;
    @NotNull
    private final String name;
    private final String description;
    private final List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
    private final String[] foreignDatabases;

    public FDWConfigDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.fdwId = config.getAttribute("fdwId");
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.foreignDatabases = CommonUtils.notEmpty((String)config.getAttribute("databases")).split(",");
        for (IConfigurationElement prop : ArrayUtils.safeArray((Object[])config.getChildren("propertyGroup"))) {
            this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getFdwId() {
        return this.fdwId;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getForeignDatabases() {
        return this.foreignDatabases;
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public boolean matches(DBPDataSourceContainer dataSource) {
        String[] stringArray = this.foreignDatabases;
        int n = this.foreignDatabases.length;
        int n2 = 0;
        while (n2 < n) {
            String dbId = stringArray[n2];
            if (!dbId.isEmpty() && dataSource.getDriver().getId().contains(dbId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return this.id;
    }
}

