/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeIcon;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.NativeClientDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class DataSourceProviderDescriptor
extends AbstractDescriptor
implements DBPDataSourceProviderDescriptor {
    private static final Log log = Log.getLog(DataSourceProviderDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceProvider";
    private DataSourceProviderRegistry registry;
    private DataSourceProviderDescriptor parentProvider;
    private final String id;
    private final AbstractDescriptor.ObjectType implType;
    private final String name;
    private final String description;
    private final boolean temporary;
    private DBPImage icon;
    private DBPDataSourceProvider instance;
    private DBXTreeItem treeDescriptor;
    private final Map<String, DBXTreeNode> treeNodeMap = new HashMap<String, DBXTreeNode>();
    private boolean driversManagable;
    private final List<DBPPropertyDescriptor> driverProperties = new ArrayList<DBPPropertyDescriptor>();
    private final List<DriverDescriptor> drivers = new ArrayList<DriverDescriptor>();
    private final List<NativeClientDescriptor> nativeClients = new ArrayList<NativeClientDescriptor>();

    public DataSourceProviderDescriptor(DataSourceProviderRegistry registry, IConfigurationElement config) {
        super(config);
        int n;
        IConfigurationElement[] iConfigurationElementArray;
        Object[] trees;
        this.registry = registry;
        this.temporary = false;
        String parentId = config.getAttribute("parent");
        if (!CommonUtils.isEmpty((String)parentId)) {
            this.parentProvider = registry.getDataSourceProvider(parentId);
            if (this.parentProvider == null) {
                log.error((Object)("Provider '" + parentId + "' not found"));
            }
        }
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        if (this.icon == null) {
            this.icon = DBIcon.DATABASE_DEFAULT;
        }
        if (!ArrayUtils.isEmpty((Object[])(trees = config.getChildren("tree")))) {
            this.treeDescriptor = this.loadTreeInfo((IConfigurationElement)trees[0]);
        } else if (this.parentProvider != null) {
            this.treeDescriptor = new DBXTreeItem((AbstractDescriptor)this, null, this.parentProvider.treeDescriptor);
        }
        Object[] injections = config.getChildren("treeInjection");
        if (!ArrayUtils.isEmpty((Object[])injections)) {
            Object[] objectArray = injections;
            int n2 = injections.length;
            int n3 = 0;
            while (n3 < n2) {
                Object treeInject = objectArray[n3];
                this.injectTreeNodes((IConfigurationElement)treeInject);
                ++n3;
            }
        }
        if (this.parentProvider != null) {
            this.driverProperties.addAll(this.parentProvider.driverProperties);
        }
        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("driver-properties");
        int n4 = iConfigurationElementArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            IConfigurationElement propsElement = iConfigurationElementArray2[n5];
            iConfigurationElementArray = propsElement.getChildren("propertyGroup");
            n = iConfigurationElementArray.length;
            int n6 = 0;
            while (n6 < n) {
                IConfigurationElement prop = iConfigurationElementArray[n6];
                this.driverProperties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
                ++n6;
            }
            ++n5;
        }
        iConfigurationElementArray2 = config.getChildren("drivers");
        n4 = iConfigurationElementArray2.length;
        n5 = 0;
        while (n5 < n4) {
            IConfigurationElement driversElement = iConfigurationElementArray2[n5];
            this.driversManagable = driversElement.getAttribute("managable") == null || CommonUtils.getBoolean((String)driversElement.getAttribute("managable"));
            iConfigurationElementArray = driversElement.getChildren("driver");
            n = iConfigurationElementArray.length;
            int n7 = 0;
            while (n7 < n) {
                IConfigurationElement driverElement = iConfigurationElementArray[n7];
                try {
                    this.drivers.add(this.loadDriver(driverElement));
                }
                catch (Exception e) {
                    log.error((Object)"Error loading driver", (Throwable)e);
                }
                ++n7;
            }
            ++n5;
        }
        iConfigurationElementArray2 = config.getChildren("nativeClients");
        n4 = iConfigurationElementArray2.length;
        n5 = 0;
        while (n5 < n4) {
            IConfigurationElement nativeClientsElement = iConfigurationElementArray2[n5];
            iConfigurationElementArray = nativeClientsElement.getChildren("client");
            n = iConfigurationElementArray.length;
            int n8 = 0;
            while (n8 < n) {
                IConfigurationElement clientElement = iConfigurationElementArray[n8];
                this.nativeClients.add(new NativeClientDescriptor(clientElement));
                ++n8;
            }
            ++n5;
        }
    }

    DataSourceProviderDescriptor(DataSourceProviderRegistry registry, String id) {
        super("org.jkiss.dbeaver.registry");
        this.registry = registry;
        this.id = id;
        this.name = id;
        this.description = "Missing datasource provider " + id;
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, DBPDataSourceProvider.class.getName());
        this.temporary = true;
        this.treeDescriptor = new DBXTreeItem((AbstractDescriptor)this, null, null, id, id, false, true, false, false, true, null, null);
    }

    void patchConfigurationFrom(IConfigurationElement config) {
        Object[] injections = config.getChildren("treeInjection");
        if (!ArrayUtils.isEmpty((Object[])injections)) {
            Object[] objectArray = injections;
            int n = injections.length;
            int n2 = 0;
            while (n2 < n) {
                Object treeInject = objectArray[n2];
                this.injectTreeNodes((IConfigurationElement)treeInject);
                ++n2;
            }
        }
    }

    public void dispose() {
        this.drivers.clear();
        this.instance = null;
    }

    public DataSourceProviderRegistry getRegistry() {
        return this.registry;
    }

    public DataSourceProviderDescriptor getParentProvider() {
        return this.parentProvider;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public DBPDataSourceProvider getInstance(DriverDescriptor driver) {
        if (this.instance == null) {
            this.initProviderBundle(driver);
            try {
                this.instance = (DBPDataSourceProvider)this.implType.createInstance(DBPDataSourceProvider.class);
                this.instance.init(DBWorkbench.getPlatform());
            }
            catch (Throwable ex) {
                this.instance = null;
                throw new IllegalStateException("Can't initialize data source provider '" + this.implType.getImplName() + "'", ex);
            }
        }
        return this.instance;
    }

    public DBXTreeNode getTreeDescriptor() {
        return this.treeDescriptor;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isDriversManagable() {
        return this.driversManagable;
    }

    public List<DBPPropertyDescriptor> getDriverProperties() {
        return this.driverProperties;
    }

    public DBPPropertyDescriptor getDriverProperty(String name) {
        for (DBPPropertyDescriptor prop : this.driverProperties) {
            if (!prop.getId().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public List<DriverDescriptor> getDrivers() {
        return this.drivers;
    }

    public List<DriverDescriptor> getEnabledDrivers() {
        ArrayList<DriverDescriptor> eDrivers = new ArrayList<DriverDescriptor>();
        for (DriverDescriptor driver : this.drivers) {
            if (driver.isDisabled() || driver.getReplacedBy() != null || !driver.isSupportedByLocalSystem()) continue;
            eDrivers.add(driver);
        }
        return eDrivers;
    }

    public DriverDescriptor getDriver(String id) {
        for (DriverDescriptor driver : this.drivers) {
            if (!driver.getId().equals(id)) continue;
            while (driver.getReplacedBy() != null) {
                driver = driver.getReplacedBy();
            }
            return driver;
        }
        return null;
    }

    public DriverDescriptor createDriver() {
        return this.createDriver(SecurityUtils.generateGUID((boolean)false));
    }

    public DriverDescriptor createDriver(String id) {
        return new DriverDescriptor(this, id);
    }

    public DriverDescriptor createDriver(DriverDescriptor copyFrom) {
        return new DriverDescriptor(this, SecurityUtils.generateGUID((boolean)false), copyFrom);
    }

    public void addDriver(DriverDescriptor driver) {
        this.drivers.add(driver);
    }

    public boolean removeDriver(DriverDescriptor driver) {
        if (!driver.isCustom()) {
            driver.setDisabled(true);
            driver.setModified(true);
            return true;
        }
        return this.drivers.remove((Object)driver);
    }

    public List<NativeClientDescriptor> getNativeClients() {
        return this.nativeClients;
    }

    private void initProviderBundle(DriverDescriptor driver) {
    }

    private DBXTreeItem loadTreeInfo(IConfigurationElement config) {
        DBXTreeItem treeRoot = new DBXTreeItem((AbstractDescriptor)this, null, config, config.getAttribute("path"), null, false, true, false, false, false, config.getAttribute("visibleIf"), null);
        this.loadTreeChildren(config, (DBXTreeNode)treeRoot, null);
        this.loadTreeIcon((DBXTreeNode)treeRoot, config);
        return treeRoot;
    }

    private void injectTreeNodes(IConfigurationElement config) {
        String injectPath = config.getAttribute("path");
        if (CommonUtils.isEmpty((String)injectPath)) {
            return;
        }
        String[] path = injectPath.split("/");
        if (path.length <= 0) {
            return;
        }
        if (!path[0].equals(this.treeDescriptor.getPath())) {
            return;
        }
        DBXTreeItem baseItem = this.treeDescriptor;
        int i = 1;
        while (i < path.length) {
            if ((baseItem = baseItem.findChildItemByPath(path[i])) == null) {
                return;
            }
            ++i;
        }
        String changeFolderType = config.getAttribute("changeFolderType");
        if (changeFolderType != null) {
            DBXTreeNode parentNode = baseItem.getParent();
            if (parentNode instanceof DBXTreeFolder) {
                ((DBXTreeFolder)parentNode).setType(changeFolderType);
            } else {
                log.error((Object)("Can't update folder type to " + changeFolderType));
            }
        } else {
            String afterPath = config.getAttribute("after");
            DBXTreeItem afterItem = null;
            if (afterPath != null) {
                afterItem = baseItem.findChildItemByPath(afterPath);
            }
            this.loadTreeChildren(config, (DBXTreeNode)baseItem, afterItem);
        }
    }

    private void loadTreeChildren(IConfigurationElement config, DBXTreeNode parent, DBXTreeItem afterItem) {
        Object[] children = config.getChildren();
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.loadTreeNode(parent, (IConfigurationElement)child, afterItem);
                ++n2;
            }
        }
    }

    private void loadTreeNode(DBXTreeNode parent, IConfigurationElement config, DBXTreeItem afterItem) {
        DBXTreeNode child;
        block23: {
            String nodeType;
            block22: {
                child = null;
                String refId = config.getAttribute("ref");
                if (CommonUtils.isEmpty((String)refId)) break block22;
                child = this.treeNodeMap.get(refId);
                if (child != null) {
                    parent.addChild(child);
                } else {
                    log.warn((Object)("Bad node reference: " + refId));
                }
                break block23;
            }
            switch (nodeType = config.getName()) {
                case "folder": {
                    child = new DBXTreeFolder((AbstractDescriptor)this, parent, config, config.getAttribute("type"), CommonUtils.getBoolean((String)config.getAttribute("navigable"), (boolean)true), CommonUtils.getBoolean((String)config.getAttribute("virtual")), config.getAttribute("visibleIf"));
                    break;
                }
                case "items": {
                    String recursive = config.getAttribute("recursive");
                    child = new DBXTreeItem((AbstractDescriptor)this, parent, config, config.getAttribute("path"), config.getAttribute("property"), CommonUtils.getBoolean((String)config.getAttribute("optional")), CommonUtils.getBoolean((String)config.getAttribute("navigable"), (boolean)true), CommonUtils.getBoolean((String)config.getAttribute("inline")), CommonUtils.getBoolean((String)config.getAttribute("virtual")), CommonUtils.getBoolean((String)config.getAttribute("standalone")), config.getAttribute("visibleIf"), recursive);
                    break;
                }
                case "treeContribution": {
                    String contrCategory = config.getAttribute("category");
                    if (parent instanceof DBXTreeFolder) {
                        ((DBXTreeFolder)parent).addContribution(contrCategory);
                        break;
                    }
                    log.warn((Object)"treeContribution allowed only inside folders");
                    break;
                }
                case "object": {
                    child = new DBXTreeObject((AbstractDescriptor)this, parent, config, config.getAttribute("visibleIf"), config.getAttribute("label"), config.getAttribute("description"), config.getAttribute("editor"));
                    break;
                }
            }
            if (child != null) {
                if (!CommonUtils.isEmpty((String)child.getId())) {
                    this.treeNodeMap.put(child.getId(), child);
                }
                this.loadTreeHandlers(child, config);
                this.loadTreeIcon(child, config);
                this.loadTreeChildren(config, child, null);
            }
        }
        if (child != null && afterItem != null) {
            parent.moveChildAfter(child, afterItem);
        }
    }

    private void loadTreeHandlers(DBXTreeNode node, IConfigurationElement config) {
        Object[] handlerElements = config.getChildren("handler");
        if (!ArrayUtils.isEmpty((Object[])handlerElements)) {
            Object[] objectArray = handlerElements;
            int n = handlerElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object iconElement = objectArray[n2];
                try {
                    DBXTreeNodeHandler.Action action = DBXTreeNodeHandler.Action.valueOf((String)iconElement.getAttribute("action"));
                    String performName = iconElement.getAttribute("perform");
                    String command = iconElement.getAttribute("command");
                    DBXTreeNodeHandler.Perform perform = !CommonUtils.isEmpty((String)performName) ? DBXTreeNodeHandler.Perform.valueOf((String)performName) : (!CommonUtils.isEmpty((String)command) ? DBXTreeNodeHandler.Perform.command : DBXTreeNodeHandler.Perform.none);
                    node.addActionHandler(action, perform, command);
                }
                catch (Exception e) {
                    log.error((Object)"Error adding node handler", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    private void loadTreeIcon(DBXTreeNode node, IConfigurationElement config) {
        DBPImage defaultImage;
        String defaultIcon = config.getAttribute("icon");
        Object[] iconElements = config.getChildren("icon");
        if (!ArrayUtils.isEmpty((Object[])iconElements)) {
            Object[] objectArray = iconElements;
            int n = iconElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object iconElement = objectArray[n2];
                String icon = iconElement.getAttribute("icon");
                String expr = iconElement.getAttribute("if");
                boolean isDefault = CommonUtils.getBoolean((String)iconElement.getAttribute("default"));
                if (isDefault && CommonUtils.isEmpty((String)expr)) {
                    defaultIcon = icon;
                } else {
                    DBPImage iconImage = this.iconToImage(icon);
                    if (iconImage != null) {
                        node.addIcon(new DBXTreeIcon(expr, iconImage));
                    }
                }
                ++n2;
            }
        }
        if (defaultIcon != null && (defaultImage = this.iconToImage(defaultIcon)) != null) {
            node.setDefaultIcon(defaultImage);
        }
    }

    private DriverDescriptor loadDriver(IConfigurationElement config) {
        return new DriverDescriptor(this, config);
    }

    public String toString() {
        return this.id;
    }

    public String getFullIdentifier() {
        return String.valueOf(this.getPluginId()) + '/' + this.id;
    }

    public DriverDescriptor getDriverByName(String category, String name) {
        if (category != null && category.isEmpty()) {
            category = null;
        }
        for (DriverDescriptor driver : this.drivers) {
            if (!CommonUtils.equalObjects((Object)category, (Object)driver.getCategory()) || !CommonUtils.equalObjects((Object)name, (Object)driver.getName())) continue;
            return driver;
        }
        return null;
    }
}

