/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.ui.UIUtils;

public class TaskHandlerDelete
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<DBTTask> tasksToDelete = new ArrayList<DBTTask>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object element : structSelection) {
                if (!(element instanceof DBTTask)) continue;
                tasksToDelete.add((DBTTask)element);
            }
        }
        if (!tasksToDelete.isEmpty()) {
            if (tasksToDelete.size() == 1 ? !UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Delete task", (String)("Are you sure you want to delete task '" + ((DBTTask)tasksToDelete.get(0)).getName() + "'?")) : !UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Delete tasks", (String)("Are you sure you want to delete " + tasksToDelete.size() + " tasks?"))) {
                return null;
            }
            for (DBTTask task : tasksToDelete) {
                task.getProject().getTaskManager().deleteTaskConfiguration(task);
            }
        }
        return null;
    }
}

