/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.StringMatcher;
import org.eclipse.ui.internal.navigator.filters.CommonFilterContentProvider;
import org.eclipse.ui.internal.navigator.filters.CommonFilterLabelProvider;
import org.eclipse.ui.internal.navigator.filters.CustomizationTab;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class CommonFiltersTab
extends CustomizationTab {
    private static final String ALL = "*";
    private Text filterText;
    private ILabelProvider filterLabelProvider = new CommonFilterLabelProvider();
    private CommonFilterContentProvider filterContentProvider = new CommonFilterContentProvider();
    private TablePatternFilter patternFilter = new TablePatternFilter();
    private Deque<ICommonFilterDescriptor> filterDescriptorChangeHistory = new ArrayDeque<ICommonFilterDescriptor>();

    protected CommonFiltersTab(Composite parent, INavigatorContentService aContentService) {
        super(parent, aContentService);
        this.createControl();
    }

    @Override
    protected void checkStateChanged(CheckStateChangedEvent event) {
        super.checkStateChanged(event);
        ICommonFilterDescriptor filterDescriptor = (ICommonFilterDescriptor)event.getElement();
        this.filterDescriptorChangeHistory.remove(filterDescriptor);
        this.filterDescriptorChangeHistory.push(filterDescriptor);
    }

    protected ICommonFilterDescriptor[] getFilterDescriptorChangeHistory() {
        return this.filterDescriptorChangeHistory.toArray(new ICommonFilterDescriptor[this.filterDescriptorChangeHistory.size()]);
    }

    private void createControl() {
        this.createInstructionsLabel(CommonNavigatorMessages.CommonFilterSelectionDialog_Select_the_filters_to_apply);
        this.createPatternFilterText(this);
        this.createTable();
        this.getTableViewer().setContentProvider((IContentProvider)this.filterContentProvider);
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)this.filterLabelProvider);
        this.getTableViewer().setComparator((ViewerComparator)new CommonFilterComparator());
        this.getTableViewer().setInput((Object)this.getContentService());
        this.getTableViewer().addFilter((ViewerFilter)this.patternFilter);
        this.updateFiltersCheckState();
    }

    private void createPatternFilterText(Composite composite) {
        this.filterText = new Text(composite, 2436);
        GridData filterTextGridData = new GridData(768);
        this.filterText.setLayoutData((Object)filterTextGridData);
        this.filterText.setMessage(CommonNavigatorMessages.CommonFilterSelectionDialog_enter_name_of_filte_);
        this.filterText.setFont(composite.getFont());
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = CommonFiltersTab.this.getTable().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    CommonFiltersTab.this.getTable().setFocus();
                } else if (e.character == '\r') {
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (CommonFiltersTab.this.getTableViewer().getTable().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        TableItem item;
                        boolean hasFocus = CommonFiltersTab.this.getTable().setFocus();
                        if (hasFocus && CommonFiltersTab.this.filterText.getText().trim().length() > 0 && (item = this.getFirstHighlightedItem(CommonFiltersTab.this.getTable().getItems())) != null) {
                            CommonFiltersTab.this.getTable().setSelection(new TableItem[]{item});
                            ISelection sel = CommonFiltersTab.this.getTableViewer().getSelection();
                            CommonFiltersTab.this.getTableViewer().setSelection(sel, true);
                        }
                    }
                }
            }

            private TableItem getFirstHighlightedItem(TableItem[] items) {
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (CommonFiltersTab.this.patternFilter.match(item.getText())) {
                        return item;
                    }
                    ++n2;
                }
                return null;
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonFiltersTab.this.textChanged();
            }
        });
    }

    void setInitialFocus() {
        this.filterText.forceFocus();
    }

    private void textChanged() {
        this.patternFilter.setPattern(this.filterText.getText());
        this.getTableViewer().refresh();
        for (Object checkedItem : this.getCheckedItems()) {
            this.getTableViewer().setChecked(checkedItem, true);
        }
    }

    private void updateFiltersCheckState() {
        INavigatorFilterService filterService = this.getContentService().getFilterService();
        Object[] objectArray = this.filterContentProvider.getElements(this.getContentService());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            ICommonFilterDescriptor filterDescriptor = (ICommonFilterDescriptor)child;
            if (filterService.isActive(filterDescriptor.getId())) {
                this.getTableViewer().setChecked(child, true);
                this.getCheckedItems().add(child);
            } else {
                this.getTableViewer().setChecked(child, false);
            }
            ++n2;
        }
    }

    private static class CommonFilterComparator
    extends ViewerComparator {
        private CommonFilterComparator() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            Arrays.sort(elements, (o1, o2) -> {
                ICommonFilterDescriptor lvalue = (ICommonFilterDescriptor)o1;
                ICommonFilterDescriptor rvalue = (ICommonFilterDescriptor)o2;
                return lvalue.getName().compareTo(rvalue.getName());
            });
        }
    }

    private class TablePatternFilter
    extends ViewerFilter {
        private StringMatcher matcher = null;

        private TablePatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.match(CommonFiltersTab.this.filterLabelProvider.getText(element));
        }

        protected void setPattern(String newPattern) {
            if (newPattern == null || newPattern.trim().length() == 0) {
                this.matcher = new StringMatcher(CommonFiltersTab.ALL, true, false);
            } else {
                String patternString = CommonFiltersTab.ALL + newPattern + CommonFiltersTab.ALL;
                this.matcher = new StringMatcher(patternString, true, false);
            }
        }

        protected boolean match(String input) {
            if (input == null) {
                return false;
            }
            return this.matcher == null || this.matcher.match(input);
        }
    }
}

