/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class StringInlineEditor
extends BaseValueEditor<Control> {
    private static final int MAX_STRING_LENGTH = 65535;

    public StringInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Control createControl(Composite editPlaceholder) {
        boolean inline;
        boolean bl = inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        if (inline) {
            Text editor = new Text(editPlaceholder, 2048);
            editor.setEditable(!this.valueController.isReadOnly());
            return editor;
        }
        StyledText editor = new StyledText(editPlaceholder, 578);
        editor.setEditable(!this.valueController.isReadOnly());
        editor.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        editor.setBackground(UIStyles.getDefaultTextBackground());
        editor.setForeground(UIStyles.getDefaultTextForeground());
        StyledTextUtils.fillDefaultStyledTextContextMenu((StyledText)editor);
        return editor;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        String strValue = this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT);
        if (this.control instanceof Text) {
            ((Text)this.control).setText(strValue);
            if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
                ((Text)this.control).selectAll();
            }
        } else {
            ((StyledText)this.control).setText(strValue);
            if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
                ((StyledText)this.control).selectAll();
            }
        }
    }

    @Override
    public Object extractEditorValue() throws DBCException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DBCSession session = this.valueController.getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make string value from editor");){
            String text = this.control instanceof Text ? ((Text)this.control).getText() : ((StyledText)this.control).getText();
            return this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)text, false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

