/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.utils.CommonUtils;

public class SQLServerDialect
extends JDBCSQLDialect {
    private static final String[][] TSQL_BEGIN_END_BLOCK = new String[0][];
    public static String[] SQLSERVER_EXTRA_KEYWORDS = new String[]{"TOP", "SYNONYM"};
    public static final String[][] SQLSERVER_QUOTE_STRINGS = new String[][]{{"[", "]"}, {"\"", "\""}};
    private static String[] EXEC_KEYWORDS = new String[]{"CALL", "EXEC"};
    private JDBCDataSource dataSource;

    public SQLServerDialect() {
        super("SQLServer");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        super.addSQLKeywords(Arrays.asList(SQLSERVER_EXTRA_KEYWORDS));
        this.dataSource = dataSource;
    }

    @NotNull
    public String getScriptDelimiter() {
        return "GO";
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_' || this.validCharacters.indexOf(c) != -1;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @NotNull
    public String[] getParametersPrefixes() {
        return super.getParametersPrefixes();
    }

    public boolean isDelimiterAfterQuery() {
        return SQLServerUtils.isDriverSqlServer(this.dataSource.getContainer().getDriver());
    }

    public boolean supportsSubqueries() {
        return true;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public String[][] getIdentifierQuoteStrings() {
        return SQLSERVER_QUOTE_STRINGS;
    }

    public String[][] getBlockBoundStrings() {
        return TSQL_BEGIN_END_BLOCK;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        if (SQLServerUtils.isDriverSqlServer(this.dataSource.getContainer().getDriver())) {
            if (this.dataSource.isServerVersionAtLeast(10, 0)) {
                return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
            }
            return super.getMultiValueInsertMode();
        }
        return super.getMultiValueInsertMode();
    }

    /*
     * Exception decompiling
     */
    public String getColumnTypeModifiers(DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl56 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl56 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters) {
        ArrayList inParameters = new ArrayList();
        int maxParamLength = this.getMaxParameterLength(parameters, inParameters);
        String schemaName = proc.getContainer().getParentObject().getName();
        sql.append("USE [").append(schemaName).append("]\n");
        sql.append("GO\n\n");
        sql.append("DECLARE\t@return_value int\n\n");
        sql.append("EXEC\t@return_value = [").append(proc.getContainer().getName()).append("].[").append(proc.getName()).append("]\n");
        int i = 0;
        while (i < inParameters.size()) {
            String name = ((DBSProcedureParameter)inParameters.get(i)).getName();
            sql.append("\t\t").append(name).append(" = :").append(CommonUtils.escapeIdentifier((String)name));
            if (i < inParameters.size() - 1) {
                sql.append(", ");
            } else {
                sql.append(" ");
            }
            int width = maxParamLength + 70 - name.length() / 2;
            String typeName = ((DBSProcedureParameter)inParameters.get(i)).getParameterType().getFullTypeName();
            sql.append(CommonUtils.fixedLengthString((String)("-- put the " + name + " parameter value instead of '?' (" + typeName + ")\n"), (int)width));
            ++i;
        }
        sql.append("\nSELECT\t'Return Value' = @return_value\n\n");
        sql.append("GO\n\n");
    }
}

