/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.spanner.views;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.spanner.SpannerActivator;
import org.jkiss.dbeaver.ext.spanner.views.SpannerMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SpannerConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static final Log log = Log.getLog(SpannerConnectionPage.class);
    private Text projectText;
    private Text instanceText;
    private Text databaseText;
    private TextWithOpenFile privateKeyFile;
    private static ImageDescriptor logoImage = SpannerActivator.getImageDescriptor("icons/spanner_logo.png");
    private DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)SpannerMessages.label_connection, (int)2, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.projectText = UIUtils.createLabelText((Composite)addrGroup, (String)SpannerMessages.label_project, (String)"");
        this.projectText.addModifyListener(textListener);
        this.instanceText = UIUtils.createLabelText((Composite)addrGroup, (String)"Instance", (String)"");
        this.instanceText.setToolTipText("Spanner Instance ID");
        this.instanceText.addModifyListener(textListener);
        this.databaseText = UIUtils.createLabelText((Composite)addrGroup, (String)"Database", (String)"");
        this.databaseText.setToolTipText("Spanner Database ID");
        this.databaseText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SpannerMessages.label_private_key_path);
        this.privateKeyFile = new TextWithOpenFile((Composite)addrGroup, SpannerMessages.label_private_key_path, new String[]{"*", "*.json"});
        GridData gd = new GridData(800);
        this.privateKeyFile.setLayoutData((Object)gd);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    public boolean isComplete() {
        return this.projectText != null && !CommonUtils.isEmpty((String)this.projectText.getText()) && this.instanceText != null && !CommonUtils.isEmpty((String)this.instanceText.getText()) && this.databaseText != null && !CommonUtils.isEmpty((String)this.databaseText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.projectText != null) {
            this.projectText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        }
        if (this.instanceText != null) {
            this.instanceText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        }
        if (this.databaseText != null) {
            this.databaseText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        if (this.privateKeyFile != null) {
            this.privateKeyFile.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("PvtKeyPath")));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.projectText != null) {
            connectionInfo.setServerName(this.projectText.getText().trim());
        }
        if (this.instanceText != null) {
            connectionInfo.setHostName(this.instanceText.getText().trim());
        }
        if (this.databaseText != null) {
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
        }
        if (this.privateKeyFile != null) {
            connectionInfo.setProviderProperty("PvtKeyPath", this.privateKeyFile.getText());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[]{this.driverPropsPage};
    }
}

