/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards.custom;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.import_config.wizards.custom.ConfigImportWizardCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ConfigImportWizardPageCustomSettings
extends WizardPage {
    private TextWithOpenFile filePathText;
    private Button xmlButton;
    private Button csvButton;
    private File inputFile;
    private Combo encodingCombo;

    protected ConfigImportWizardPageCustomSettings() {
        super("Settings");
        this.setTitle("Input settings");
        this.setDescription("Connections file format settings");
    }

    public void createControl(Composite parent) {
        Composite placeholder = new Composite(parent, 0);
        placeholder.setLayout((Layout)new GridLayout(1, true));
        Group typeGroup = UIUtils.createControlGroup((Composite)placeholder, (String)"Input type", (int)2, (int)768, (int)-1);
        this.xmlButton = new Button((Composite)typeGroup, 16);
        this.xmlButton.setText("XML");
        this.xmlButton.setSelection(true);
        this.csvButton = new Button((Composite)typeGroup, 16);
        this.csvButton.setText("CSV");
        UIUtils.createControlLabel((Composite)placeholder, (String)"Input file");
        this.filePathText = new TextWithOpenFile(placeholder, "Configuration Input File", new String[]{"*", "*.csv", "*.xml", "*.*"});
        this.filePathText.setLayoutData((Object)new GridData(768));
        this.filePathText.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigImportWizardPageCustomSettings.this.inputFile = new File(ConfigImportWizardPageCustomSettings.this.filePathText.getText());
                if (!ConfigImportWizardPageCustomSettings.this.inputFile.exists()) {
                    ConfigImportWizardPageCustomSettings.this.setErrorMessage("File '" + ConfigImportWizardPageCustomSettings.this.inputFile.getAbsolutePath() + "' doesn't exist");
                } else {
                    ConfigImportWizardPageCustomSettings.this.setErrorMessage(null);
                }
                ConfigImportWizardPageCustomSettings.this.getWizard().getContainer().updateButtons();
            }
        });
        UIUtils.createControlLabel((Composite)placeholder, (String)"File encoding");
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)placeholder, (String)GeneralUtils.DEFAULT_ENCODING);
        this.setControl((Control)placeholder);
    }

    public boolean isPageComplete() {
        return this.inputFile != null && this.inputFile.exists();
    }

    public ConfigImportWizardCustom.ImportType getImportType() {
        return this.csvButton.getSelection() ? ConfigImportWizardCustom.ImportType.CSV : ConfigImportWizardCustom.ImportType.XML;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public String getInputFileEncoding() {
        return this.encodingCombo.getText();
    }
}

