/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.common;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.navigator.project.ProjectExplorerView;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarkStorage;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarksHandlerImpl;
import org.jkiss.dbeaver.ui.resources.bookmarks.DBNBookmark;

public class NavigateBookmarkHandler
extends NavigatorHandlerObjectBase {
    private static final Log log = Log.getLog(NavigateBookmarkHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBNNode selectedNode;
        NavigatorViewBase activeNavigatorView = NavigatorUtils.getActiveNavigatorView((ExecutionEvent)event);
        if (activeNavigatorView != null && (selectedNode = NavigatorUtils.getSelectedNode((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event))) instanceof DBNBookmark) {
            IWorkbenchPage activePage;
            IViewPart dbNavigatorPart;
            BookmarkStorage storage = ((DBNBookmark)selectedNode).getStorage();
            DBPDataSourceContainer dataSourceContainer = DBUtils.findDataSource((String)storage.getDataSourceId());
            if (dataSourceContainer == null) {
                log.debug((Object)("Can't find datasource '" + storage.getDataSourceId() + "'"));
                return null;
            }
            DBNDataSource dsNode = (DBNDataSource)DBNUtils.getNodeByObject((DBSObject)dataSourceContainer);
            if (dsNode == null) {
                log.error((Object)("Can't find datasource node for '" + dataSourceContainer.getName() + "'"));
                return null;
            }
            if (activeNavigatorView instanceof ProjectExplorerView && (dbNavigatorPart = (activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage()).findView("org.jkiss.dbeaver.core.databaseNavigator")) instanceof NavigatorViewBase) {
                activeNavigatorView = (NavigatorViewBase)dbNavigatorPart;
                try {
                    activePage.showView("org.jkiss.dbeaver.core.databaseNavigator");
                }
                catch (PartInitException e) {
                    log.debug((Object)e);
                }
            }
            NavigatorViewBase navigatorView = activeNavigatorView;
            dsNode.initializeNode(null, status -> {
                if (status.isOK()) {
                    UIUtils.syncExec(() -> BookmarksHandlerImpl.navigateNodeByPath(navigatorView, dsNode, storage));
                }
            });
        }
        return null;
    }
}

