/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DataSourceAutoCommitHandler
extends AbstractDataSourceHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBCTransactionManager txnManager;
        final DBCExecutionContext context = this.getExecutionContext(event, true);
        if (context != null && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context)) != null) {
            try {
                boolean newAutocommit;
                DBPDataSourceContainer container = context.getDataSource().getContainer();
                boolean bl = newAutocommit = !container.isDefaultAutoCommit();
                if (context.isConnected()) {
                    newAutocommit = !txnManager.isAutoCommit();
                }
                final boolean autoCommit = newAutocommit;
                new AbstractJob("Set auto-commit"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        monitor.beginTask("Change connection auto-commit to " + autoCommit, 1);
                        try {
                            try {
                                monitor.subTask("Change context '" + context.getContextName() + "' auto-commit state");
                                txnManager.setAutoCommit(monitor, autoCommit);
                            }
                            catch (Exception e) {
                                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Auto-Commit", "Error while toggle auto-commit", (Throwable)e);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        DBPDataSourceContainer container;
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        boolean autoCommit = true;
        DBPTransactionIsolation isolation = null;
        DBCExecutionContext context = DataSourceAutoCommitHandler.getExecutionContext((IWorkbenchPart)activeEditor);
        if (context != null && context.isConnected()) {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
            if (txnManager != null) {
                try {
                    autoCommit = txnManager.isAutoCommit();
                    isolation = txnManager.getTransactionIsolation();
                }
                catch (DBCException e) {
                    log.warn((Object)e);
                }
            }
        } else if (activeEditor instanceof IDataSourceContainerProvider && (container = ((IDataSourceContainerProvider)activeEditor).getDataSourceContainer()) != null) {
            autoCommit = container.isDefaultAutoCommit();
            isolation = container.getActiveTransactionsIsolation();
        }
        element.setChecked(autoCommit);
        element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)(autoCommit ? UIIcon.TXN_COMMIT_AUTO : UIIcon.TXN_COMMIT_MANUAL)));
        String isolationName = isolation == null ? "?" : isolation.getTitle();
        String text = autoCommit ? NLS.bind((String)CoreMessages.action_menu_transaction_manualcommit_name, (Object)isolationName) : CoreMessages.action_menu_transaction_autocommit_name;
        element.setText(text);
        element.setTooltip(text);
    }
}

