/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.completion;

import org.eclipse.jface.text.IDocument;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionContext;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;

public class SQLCompletionRequest {
    private final SQLCompletionContext context;
    private final IDocument document;
    private final int documentOffset;
    private final SQLScriptElement activeQuery;
    private final boolean simpleMode;
    private final SQLWordPartDetector wordDetector;
    private String wordPart;
    private QueryType queryType;

    public SQLCompletionRequest(SQLCompletionContext context, IDocument document, int documentOffset, SQLScriptElement activeQuery, boolean simpleMode) {
        this.context = context;
        this.document = document;
        this.documentOffset = documentOffset;
        this.activeQuery = activeQuery;
        this.simpleMode = simpleMode;
        this.wordDetector = new SQLWordPartDetector(document, context.getSyntaxManager(), documentOffset);
        this.wordPart = this.wordDetector.getWordPart();
    }

    public SQLCompletionContext getContext() {
        return this.context;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public int getDocumentOffset() {
        return this.documentOffset;
    }

    public SQLScriptElement getActiveQuery() {
        return this.activeQuery;
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public SQLWordPartDetector getWordDetector() {
        return this.wordDetector;
    }

    public String getWordPart() {
        return this.wordPart;
    }

    public void setWordPart(String wordPart) {
        this.wordPart = wordPart;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public static enum QueryType {
        TABLE,
        JOIN,
        COLUMN,
        EXEC;

    }
}

