/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text.parser.rules;

import java.util.Arrays;
import java.util.Comparator;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class PatternRule
implements TPPredicateRule {
    protected static final int UNDEFINED = -1;
    protected TPToken fToken;
    protected char[] fStartSequence;
    protected char[] fEndSequence;
    protected int fColumn = -1;
    protected char fEscapeCharacter;
    protected boolean fEscapeContinuesLine;
    protected boolean fBreaksOnEOL;
    protected boolean fBreaksOnEOF;
    private Comparator<char[]> fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public PatternRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOL) {
        this.fStartSequence = startSequence.toCharArray();
        this.fEndSequence = endSequence == null ? new char[]{} : endSequence.toCharArray();
        this.fToken = token;
        this.fEscapeCharacter = escapeCharacter;
        this.fBreaksOnEOL = breaksOnEOL;
    }

    public PatternRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL);
        this.fBreaksOnEOF = breaksOnEOF;
    }

    public PatternRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF);
        this.fEscapeContinuesLine = escapeContinuesLine;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    protected TPToken doEvaluate(TPCharacterScanner scanner) {
        return this.doEvaluate(scanner, false);
    }

    protected TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
        int c;
        if (resume ? this.endSequenceDetected(scanner) : (c = scanner.read()) == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean endSequenceDetected(TPCharacterScanner scanner) {
        block17: {
            originalDelimiters = scanner.getLegalLineDelimiters();
            count = originalDelimiters.length;
            if (this.fLineDelimiters != null && this.fLineDelimiters.length == count) ** GOTO lbl7
            this.fSortedLineDelimiters = new char[count][];
            break block17;
lbl-1000:
            // 1 sources

            {
                --count;
lbl7:
                // 2 sources

                ** while (count > 0 && Arrays.equals((char[])this.fLineDelimiters[count - 1], (char[])originalDelimiters[count - 1]))
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        readCount = 1;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                if (this.fEscapeContinuesLine) {
                    c = scanner.read();
                    var9_9 = this.fSortedLineDelimiters;
                    var8_8 = this.fSortedLineDelimiters.length;
                    var7_7 = 0;
                    while (var7_7 < var8_8) {
                        fSortedLineDelimiter = var9_9[var7_7];
                        if (c != fSortedLineDelimiter[0] || !this.sequenceDetected(scanner, fSortedLineDelimiter, this.fBreaksOnEOF)) {
                            ++var7_7;
                            continue;
                        }
                        break;
                    }
                } else {
                    scanner.read();
                }
            } else if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (this.sequenceDetected(scanner, this.fEndSequence, this.fBreaksOnEOF)) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                var9_9 = this.fSortedLineDelimiters;
                var8_8 = this.fSortedLineDelimiters.length;
                var7_7 = 0;
                while (var7_7 < var8_8) {
                    fSortedLineDelimiter = var9_9[var7_7];
                    if (c == fSortedLineDelimiter[0] && this.sequenceDetected(scanner, fSortedLineDelimiter, this.fBreaksOnEOF)) {
                        return true;
                    }
                    ++var7_7;
                }
            }
            ++readCount;
        }
        if (!this.fBreaksOnEOF) ** GOTO lbl52
        return true;
lbl-1000:
        // 1 sources

        {
            scanner.unread();
            --readCount;
lbl52:
            // 2 sources

            ** while (readCount > 0)
        }
lbl53:
        // 1 sources

        return false;
    }

    protected boolean sequenceDetected(TPCharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != sequence[i]) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (c == this.fStartSequence[0]) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : TPTokenAbstract.UNDEFINED;
        }
        return TPTokenAbstract.UNDEFINED;
    }

    @Override
    public TPToken getSuccessToken() {
        return this.fToken;
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator<char[]> {
        private DecreasingCharArrayLengthComparator() {
        }

        @Override
        public int compare(char[] o1, char[] o2) {
            return o2.length - o1.length;
        }
    }
}

