/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetJobAbstract;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;

class ResultSetJobDataRead
extends ResultSetJobAbstract
implements ILoadService<Object> {
    private DBDDataFilter dataFilter;
    private Composite progressControl;
    private int offset;
    private int maxRows;
    private Throwable error;
    private DBCStatistics statistics;
    private boolean refresh;
    private static final int PROGRESS_VISUALIZE_PERIOD = 100;

    ResultSetJobDataRead(DBSDataContainer dataContainer, DBDDataFilter dataFilter, ResultSetViewer controller, DBCExecutionContext executionContext, Composite progressControl) {
        super(String.valueOf(ResultSetMessages.controls_rs_pump_job_name) + " [" + dataContainer + "]", dataContainer, controller, executionContext);
        this.dataFilter = dataFilter;
        this.progressControl = progressControl;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public Throwable getError() {
        return this.error;
    }

    DBCStatistics getStatistics() {
        return this.statistics;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        this.error = null;
        ProgressLoaderVisualizer visualizer = new ProgressLoaderVisualizer((ILoadService)this, this.progressControl);
        DBRProgressMonitor progressMonitor = visualizer.overwriteMonitor(monitor);
        new PumpVisualizer((ProgressLoaderVisualizer<Object>)visualizer).schedule(200L);
        long fetchFlags = 2L;
        if (this.offset > 0) {
            fetchFlags |= 0x10L;
        }
        if (this.offset > 0 && this.dataContainer.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.reread.on.scroll")) {
            if (this.maxRows > 0) {
                this.maxRows += this.offset;
            }
            this.offset = 0;
        }
        if (this.refresh) {
            fetchFlags |= 0x100L;
        }
        long finalFlags = fetchFlags;
        DBCExecutionPurpose purpose = this.dataFilter != null && this.dataFilter.hasFilters() ? DBCExecutionPurpose.USER_FILTERED : DBCExecutionPurpose.USER;
        try {
            try {
                Throwable throwable = null;
                Object var10_10 = null;
                try (DBCSession session = this.getExecutionContext().openSession(progressMonitor, purpose, NLS.bind((String)ResultSetMessages.controls_rs_pump_job_context_name, (Object)this.dataContainer.toString()));){
                    DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)session.getDataSource(), monitor1 -> {
                        try {
                            this.statistics = this.dataContainer.readData((DBCExecutionSource)this, session, (DBDDataReceiver)this.controller.getDataReceiver(), this.dataFilter, (long)this.offset, (long)this.maxRows, finalFlags, 0);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBException e) {
                this.error = e;
                visualizer.completeLoading(null);
            }
        }
        finally {
            visualizer.completeLoading(null);
        }
        return Status.OK_STATUS;
    }

    public String getServiceName() {
        return "ResultSet data pump";
    }

    public Object evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return null;
    }

    public Object getFamily() {
        return this.getExecutionController();
    }

    private class PumpVisualizer
    extends UIJob {
        private ProgressLoaderVisualizer<Object> visualizer;

        PumpVisualizer(ProgressLoaderVisualizer<Object> visualizer) {
            super(UIUtils.getDisplay(), "RSV Pump Visualizer");
            this.setSystem(true);
            this.visualizer = visualizer;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!ResultSetJobDataRead.this.controller.getDataReceiver().isDataReceivePaused()) {
                this.visualizer.visualizeLoading();
            } else {
                this.visualizer.resetStartTime();
            }
            if (!this.visualizer.isCompleted()) {
                this.schedule(100L);
            }
            return Status.OK_STATUS;
        }
    }
}

