/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;

public class DisplayedContent
implements StyledTextContent {
    private StringBuilder data = null;
    private Set<TextChangeListener> textListeners = null;
    private int numberOfColumns = -1;
    private int linesTimesColumns = -1;

    DisplayedContent(int numberOfColumns, int numberOfLines) {
        this.data = new StringBuilder(numberOfColumns * numberOfLines * 2);
        this.textListeners = new HashSet<TextChangeListener>();
        this.setDimensions(numberOfColumns, numberOfLines);
    }

    public void addTextChangeListener(TextChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add a null listener");
        }
        this.textListeners.add(listener);
    }

    public int getCharCount() {
        return this.data.length();
    }

    public String getLine(int lineIndex) {
        return this.getTextRange(lineIndex * this.numberOfColumns, this.numberOfColumns);
    }

    public int getLineAtOffset(int offset) {
        int result = offset / this.numberOfColumns;
        if (result >= this.getLineCount()) {
            return this.getLineCount() - 1;
        }
        return result;
    }

    public int getLineCount() {
        return (this.data.length() - 1) / this.numberOfColumns + 1;
    }

    public String getLineDelimiter() {
        return "";
    }

    public int getOffsetAtLine(int lineIndex) {
        return lineIndex * this.numberOfColumns;
    }

    public String getTextRange(int start, int length) {
        int dataLength = this.data.length();
        if (start > dataLength) {
            return "";
        }
        return this.data.substring(start, Math.min(dataLength, start + length));
    }

    public void removeTextChangeListener(TextChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot remove a null listener");
        }
        this.textListeners.remove(listener);
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
        int length = text.length();
        if (length != replaceLength || start + length > this.data.length()) {
            return;
        }
        this.data.replace(start, start + length, text);
    }

    void setDimensions(int columns, int lines) {
        this.numberOfColumns = columns <= 0 ? 1 : columns;
        this.linesTimesColumns = lines * columns;
        this.setText(this.data.toString());
    }

    public void setText(String text) {
        this.data.setLength(0);
        this.data.append(text.substring(0, Math.min(text.length(), this.linesTimesColumns)));
        TextChangedEvent changedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener textListener : this.textListeners) {
            textListener.textSet(changedEvent);
        }
    }

    public void shiftLines(String text, boolean forward) {
        if (text.length() == 0) {
            return;
        }
        int linesInText = (text.length() - 1) / this.numberOfColumns + 1;
        int currentLimit = Math.min(this.data.length(), this.linesTimesColumns);
        TextChangingEvent event = new TextChangingEvent((StyledTextContent)this);
        event.start = forward ? 0 : currentLimit;
        event.newText = text;
        event.replaceCharCount = 0;
        event.newCharCount = text.length();
        event.replaceLineCount = 0;
        event.newLineCount = linesInText;
        for (TextChangeListener myTextListener : this.textListeners) {
            myTextListener.textChanging(event);
        }
        this.data.insert(event.start, text);
        TextChangedEvent changedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener myTextListener : this.textListeners) {
            myTextListener.textChanged(changedEvent);
        }
        event = new TextChangingEvent((StyledTextContent)this);
        event.start = forward ? this.linesTimesColumns - 1 : 0;
        event.newText = "";
        event.replaceCharCount = linesInText * this.numberOfColumns - this.linesTimesColumns + currentLimit;
        event.newCharCount = 0;
        event.replaceLineCount = linesInText;
        event.newLineCount = 0;
        for (TextChangeListener myTextListener : this.textListeners) {
            myTextListener.textChanging(event);
        }
        if (forward) {
            this.data.delete(this.linesTimesColumns, this.linesTimesColumns + event.replaceCharCount);
        } else {
            this.data.delete(0, event.replaceCharCount);
        }
        changedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener myTextListener : this.textListeners) {
            myTextListener.textChanged(changedEvent);
        }
    }
}

