/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.dialogs.GotoObjectDialog;
import org.jkiss.utils.ArrayUtils;

public class NavigatorHandlerObjectGoto
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBSObject object;
        Object element;
        ISelection selection;
        DBCExecutionContext context = null;
        DBSObject container = null;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof DBPContextProvider) {
            context = ((DBPContextProvider)activePart).getExecutionContext();
        } else if (activePart instanceof INavigatorModelView && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof DBSWrapper && (object = ((DBSWrapper)element).getObject()) != null) {
            container = object;
            while (container instanceof DBSFolder) {
                container = container.getParentObject();
            }
            context = DBUtils.getDefaultContext((DBSObject)object, (boolean)true);
        }
        if (context == null) {
            DBWorkbench.getPlatformUI().showError("Go to object", "No active datasource");
            return null;
        }
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        GotoObjectDialog dialog = new GotoObjectDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), context, container);
        dialog.open();
        Object[] objectsToOpen = dialog.getResult();
        if (!ArrayUtils.isEmpty((Object[])objectsToOpen)) {
            Collection<DBNDatabaseNode> nodes = NavigatorHandlerObjectBase.getNodesByObjects(Arrays.asList(objectsToOpen));
            for (DBNDatabaseNode node : nodes) {
                NavigatorUtils.openNavigatorNode(node, workbenchWindow);
            }
        }
        return null;
    }
}

