/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.lang.reflect.InvocationTargetException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseRestoreSettings
extends PostgreBackupRestoreSettings {
    private static final Log log = Log.getLog(PostgreDatabaseRestoreSettings.class);
    private String inputFile;
    private boolean cleanFirst;
    private PostgreDatabaseRestoreInfo restoreInfo;

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public boolean isCleanFirst() {
        return this.cleanFirst;
    }

    public void setCleanFirst(boolean cleanFirst) {
        this.cleanFirst = cleanFirst;
    }

    public PostgreDatabaseRestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    public void setRestoreInfo(PostgreDatabaseRestoreInfo restoreInfo) {
        this.restoreInfo = restoreInfo;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        super.loadSettings(runnableContext, store);
        this.inputFile = store.getString("pg.restore.inputFile");
        this.cleanFirst = store.getBoolean("pg.restore.cleanFirst");
        String catalogId = store.getString("pg.restore.database");
        if (!CommonUtils.isEmpty((String)catalogId)) {
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        PostgreDatabase database = (PostgreDatabase)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)this.getProject(), (String)catalogId);
                        if (database == null) {
                            throw new DBException("Database " + catalogId + " not found");
                        }
                        this.restoreInfo = new PostgreDatabaseRestoreInfo(database);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Error loading objects configuration", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) {
        super.saveSettings(runnableContext, store);
        store.setValue("pg.restore.inputFile", this.inputFile);
        store.setValue("pg.restore.cleanFirst", this.cleanFirst);
        store.setValue("pg.restore.database", DBUtils.getObjectFullId((DBSObject)this.restoreInfo.getDatabase()));
    }
}

