/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.model.data;

import java.sql.SQLException;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class SQLiteValueHandler
extends JDBCAbstractValueHandler {
    private static final Log log = Log.getLog(SQLiteValueHandler.class);
    private final DBDDataFormatterProfile formatterProfile;
    private final DBSTypedObject type;
    private DBDDataFormatter numberFormatter;
    private DBDDataFormatter timestampFormatter;

    public SQLiteValueHandler(DBSTypedObject type, DBDDataFormatterProfile formatterProfile) {
        this.formatterProfile = formatterProfile;
        this.type = type;
    }

    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object object = resultSet.getObject(index);
        return this.getValueFromObject(session, type, object, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        statement.setObject(paramIndex, value);
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy) throws DBCException {
        return object;
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof Number) {
            if (format == DBDDisplayFormat.NATIVE || format == DBDDisplayFormat.EDIT) {
                return DBValueFormatting.convertNumberToNativeString((Number)((Number)value));
            }
            if (this.numberFormatter == null) {
                try {
                    this.numberFormatter = this.formatterProfile.createFormatter("number", this.type);
                }
                catch (Exception e) {
                    log.error((Object)"Can't create numberFormatter for number value handler", (Throwable)e);
                    this.numberFormatter = DefaultDataFormatter.INSTANCE;
                }
            }
            return this.numberFormatter.formatValue(value);
        }
        if (value instanceof Date) {
            if (this.timestampFormatter == null) {
                try {
                    this.timestampFormatter = this.formatterProfile.createFormatter("timestamp", this.type);
                }
                catch (Exception e) {
                    log.error((Object)"Can't create timestampFormatter for timestamp value handler", (Throwable)e);
                    this.timestampFormatter = DefaultDataFormatter.INSTANCE;
                }
            }
            return this.timestampFormatter.formatValue(value);
        }
        return super.getValueDisplayString(column, value, format);
    }
}

