/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLServerExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<SQLServerDatabase, SQLServerSchema> {
    private static final Log log = Log.getLog(SQLServerExecutionContext.class);
    private String activeDatabaseName;

    SQLServerExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)super.getDataSource();
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public String getActiveDatabaseName() {
        return this.activeDatabaseName;
    }

    public SQLServerDatabase getDefaultCatalog() {
        return this.getDataSource().getDatabase(this.activeDatabaseName);
    }

    public SQLServerSchema getDefaultSchema() {
        SQLServerDatabase defaultCatalog = this.getDefaultCatalog();
        return defaultCatalog == null ? null : defaultCatalog.getSchema("dbo");
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, SQLServerDatabase catalog, SQLServerSchema schema) throws DBCException {
        if (this.activeDatabaseName != null && this.activeDatabaseName.equals(catalog.getName())) {
            return;
        }
        SQLServerDatabase oldActiveDatabase = this.getDefaultCatalog();
        if (!this.setCurrentDatabase(monitor, catalog)) {
            return;
        }
        try {
            catalog.getSchemas(monitor);
        }
        catch (DBException e) {
            log.debug((Object)"Error caching database schemas", (Throwable)e);
        }
        this.activeDatabaseName = catalog.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveDatabase, (DBSObject)catalog);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, SQLServerSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active database");){
                DBPConnectionBootstrap bootstrap;
                if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultSchemaName())) {
                    this.setCurrentDatabase(monitor, bootstrap.getDefaultCatalogName());
                }
                this.activeDatabaseName = SQLServerUtils.getCurrentDatabase(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
        return false;
    }

    boolean setCurrentDatabase(DBRProgressMonitor monitor, SQLServerDatabase object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return false;
        }
        String databaseName = object.getName();
        return this.setCurrentDatabase(monitor, databaseName);
    }

    private boolean setCurrentDatabase(DBRProgressMonitor monitor, String databaseName) {
        block12: {
            Throwable throwable = null;
            Object var4_6 = null;
            JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active database");
            try {
                SQLServerUtils.setCurrentDatabase(session, databaseName);
                this.activeDatabaseName = databaseName;
                if (session == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e);
                    return false;
                }
            }
            session.close();
        }
        return true;
    }
}

