/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.txn;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceCommitHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceRollbackHandler;
import org.jkiss.dbeaver.ui.controls.txn.TransactionInfoDialog;
import org.jkiss.utils.ArrayUtils;

public class PendingTransactionsDialog
extends TransactionInfoDialog {
    private static final String DIALOG_ID = "DBeaver.PendingTransactionsDialog";
    private Tree contextTree;
    private DBCExecutionContext selectedContext;
    private Button commitButton;
    private Button rollbackButton;

    private PendingTransactionsDialog(Shell parentShell, IWorkbenchPart activePart) {
        super(parentShell, "Pending transactions", activePart);
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected DBCExecutionContext getCurrentContext() {
        return this.selectedContext;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.contextTree = new Tree(composite, 67584);
        this.contextTree.setHeaderVisible(true);
        this.contextTree.setLinesVisible(true);
        TreeColumn colName = new TreeColumn(this.contextTree, 0);
        colName.setText("Connection");
        TreeColumn colTxn = new TreeColumn(this.contextTree, 131072);
        colTxn.setText("Transaction");
        GridData gd = new GridData(1808);
        gd.heightHint = this.contextTree.getHeaderHeight() + this.contextTree.getItemHeight() * 5;
        this.contextTree.setLayoutData((Object)gd);
        this.contextTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null && e.item.getData() instanceof DBCExecutionContext) {
                    PendingTransactionsDialog.this.selectedContext = (DBCExecutionContext)e.item.getData();
                } else {
                    PendingTransactionsDialog.this.selectedContext = null;
                }
                boolean hasTransaction = PendingTransactionsDialog.this.selectedContext != null && QMUtils.isTransactionActive((DBCExecutionContext)PendingTransactionsDialog.this.selectedContext);
                PendingTransactionsDialog.this.commitButton.setEnabled(hasTransaction);
                PendingTransactionsDialog.this.rollbackButton.setEnabled(hasTransaction);
                PendingTransactionsDialog.this.logViewer.setFilter(PendingTransactionsDialog.this.createContextFilter(PendingTransactionsDialog.this.selectedContext));
                PendingTransactionsDialog.this.logViewer.refresh();
            }
        });
        this.closeOnFocusLost(new Control[]{this.contextTree});
        Composite controlPanel = UIUtils.createPlaceholder((Composite)composite, (int)3, (int)5);
        controlPanel.setLayoutData((Object)new GridData(768));
        final Button showAllCheck = UIUtils.createCheckbox((Composite)controlPanel, (String)"Show all connections", (String)"Show all datasource connections. Otherwise shows only transactional connections.", (boolean)false, (int)1);
        showAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingTransactionsDialog.this.loadContexts(showAllCheck.getSelection());
            }
        });
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        showAllCheck.setLayoutData((Object)gd);
        this.commitButton = UIUtils.createPushButton((Composite)controlPanel, (String)"Commit", (Image)DBeaverIcons.getImage((DBPImage)UIIcon.TXN_COMMIT));
        this.commitButton.setEnabled(false);
        this.commitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingTransactionsDialog.this.endTransaction(true);
            }
        });
        this.rollbackButton = UIUtils.createPushButton((Composite)controlPanel, (String)"Rollback", (Image)DBeaverIcons.getImage((DBPImage)UIIcon.TXN_ROLLBACK));
        this.rollbackButton.setEnabled(false);
        this.rollbackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingTransactionsDialog.this.endTransaction(false);
            }
        });
        this.closeOnFocusLost(new Control[]{showAllCheck, this.commitButton, this.rollbackButton});
        super.createTransactionLogPanel(composite);
        this.loadContexts(false);
        return parent;
    }

    private void endTransaction(boolean commit) {
        if (this.selectedContext == null) {
            return;
        }
        if (commit) {
            DataSourceCommitHandler.execute(this.selectedContext);
        } else {
            DataSourceRollbackHandler.execute(this.selectedContext);
        }
        this.commitButton.setEnabled(false);
        this.rollbackButton.setEnabled(false);
    }

    /*
     * Could not resolve type clashes
     */
    private void loadContexts(boolean showAllContexts) {
        this.contextTree.removeAll();
        for (DBPDataSourceContainer dataSource : DataSourceRegistry.getAllDataSources()) {
            if (!dataSource.isConnected() || dataSource.getDataSource() == null) continue;
            for (DBSInstance instance : dataSource.getDataSource().getAvailableInstances()) {
                Object[] allContexts = instance.getAllContexts();
                if (ArrayUtils.isEmpty((Object[])allContexts)) continue;
                ArrayList<Object> txnContexts = new ArrayList<Object>();
                Object[] objectArray = allContexts;
                int n = allContexts.length;
                int n2 = 0;
                while (n2 < n) {
                    Object context = objectArray[n2];
                    if (showAllContexts || QMUtils.isTransactionActive((DBCExecutionContext)context)) {
                        txnContexts.add(context);
                    }
                    ++n2;
                }
                if (txnContexts.isEmpty()) continue;
                TreeItem dsItem = new TreeItem(this.contextTree, 0);
                dsItem.setText(dataSource.getName());
                dsItem.setImage(DBeaverIcons.getImage((DBPImage)dataSource.getDriver().getIcon()));
                dsItem.setData((Object)dataSource);
                for (DBCExecutionContext context : txnContexts) {
                    QMTransactionState txnState = QMUtils.getTransactionState((DBCExecutionContext)context);
                    TreeItem contextItem = new TreeItem(dsItem, 0);
                    contextItem.setText(0, context.getContextName());
                    String stateString = String.valueOf(String.valueOf(txnState.getUpdateCount())) + "/" + String.valueOf(txnState.getExecuteCount());
                    contextItem.setText(1, stateString);
                    contextItem.setData((Object)context);
                }
                dsItem.setExpanded(true);
            }
        }
        UIUtils.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                UIUtils.packColumns((Tree)PendingTransactionsDialog.this.contextTree);
            }
        });
    }

    public static void showDialog(Shell shell) {
        IWorkbenchPart activePart = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart == null) {
            DBWorkbench.getPlatformUI().showError("No active part", "No active part.");
        } else {
            PendingTransactionsDialog dialog = new PendingTransactionsDialog(shell, activePart);
            dialog.setModeless(true);
            dialog.open();
        }
    }
}

