/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PropertySourceMap
implements DBPPropertySource {
    private List<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
    private Map<?, ?> items;

    public PropertySourceMap(Map<?, ?> map) {
        this.items = new LinkedHashMap(map);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.props.add(new ItemPropertyDescriptor(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public Object getEditableValue() {
        return this;
    }

    @Override
    public DBPPropertyDescriptor[] getPropertyDescriptors2() {
        return this.props.toArray(new DBPPropertyDescriptor[this.props.size()]);
    }

    @Override
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
        return this.items.get(id);
    }

    @Override
    public boolean isPropertySet(Object id) {
        return false;
    }

    @Override
    public boolean isPropertyResettable(Object id) {
        return false;
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
    }

    @Override
    public void resetPropertyValueToDefault(Object id) {
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object id, Object value) {
    }

    @Override
    public boolean isDirty(Object id) {
        return false;
    }

    public String toString() {
        return "<...>";
    }

    private class ItemPropertyDescriptor
    implements DBPPropertyDescriptor {
        private Object name;
        private Object value;

        public ItemPropertyDescriptor(Object name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getCategory() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public Class<?> getDataType() {
            return Object.class;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public boolean isEditable(Object object) {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return DBUtils.getObjectShortName(this.name);
        }

        @Override
        @NotNull
        public Object getId() {
            return this.name;
        }
    }
}

