/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class DataSourceAuthModelDescriptor
extends AbstractDescriptor
implements DBPAuthModelDescriptor {
    private static final Log log = Log.getLog(DataSourceAuthModelDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceAuth";
    private final String id;
    private final AbstractDescriptor.ObjectType implType;
    private final String name;
    private final String description;
    private DBPImage icon;
    private List<DataSourceInfo> dataSources = new ArrayList<DataSourceInfo>();
    private List<String> replaces = new ArrayList<String>();
    private DBAAuthModel instance;

    public DataSourceAuthModelDescriptor(IConfigurationElement config) {
        super(config);
        IConfigurationElement dsConfig;
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        if (this.icon == null) {
            this.icon = DBIcon.TREE_PACKAGE;
        }
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("datasource");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            dsConfig = iConfigurationElementArray[n2];
            this.dataSources.add(new DataSourceInfo(dsConfig));
            ++n2;
        }
        iConfigurationElementArray = config.getChildren("replace");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            dsConfig = iConfigurationElementArray[n2];
            this.replaces.add(dsConfig.getAttribute("model"));
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String getImplClassName() {
        return this.implType.getImplName();
    }

    public boolean isApplicableTo(DBPDriver driver) {
        return this.appliesTo(driver);
    }

    @NotNull
    public DBAAuthModel getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (DBAAuthModel)this.implType.createInstance(DBAAuthModel.class);
            }
            catch (Throwable ex) {
                this.instance = null;
                throw new IllegalStateException("Can't initialize data source auth model '" + this.implType.getImplName() + "'", ex);
            }
        }
        return this.instance;
    }

    boolean appliesTo(DBPDriver driver) {
        if (this.dataSources.isEmpty()) {
            return true;
        }
        for (DataSourceInfo dsi : this.dataSources) {
            if (!dsi.appliesTo(driver, null)) continue;
            return true;
        }
        return false;
    }

    public List<String> getReplaces() {
        return this.replaces;
    }

    public String toString() {
        return this.id;
    }

    public static class DataSourceInfo {
        private String id;
        private String driver;
        private JexlExpression expression;

        DataSourceInfo(IConfigurationElement cfg) {
            String condition = cfg.getAttribute("if");
            if (!CommonUtils.isEmpty((String)condition)) {
                try {
                    this.expression = DataSourceAuthModelDescriptor.parseExpression((String)condition);
                }
                catch (DBException ex) {
                    log.warn((Object)("Can't parse auth model datasource expression: " + condition), (Throwable)ex);
                }
            }
            this.id = cfg.getAttribute("id");
            this.driver = cfg.getAttribute("driver");
        }

        public boolean appliesTo(DBPDriver driver, Object context) {
            if (!CommonUtils.isEmpty((String)this.id) && !this.id.equals(driver.getProviderId())) {
                return false;
            }
            if (!CommonUtils.isEmpty((String)this.driver) && !this.driver.equals(driver.getId())) {
                return false;
            }
            if (this.expression != null) {
                try {
                    return CommonUtils.toBoolean((Object)this.expression.evaluate(DataSourceAuthModelDescriptor.makeContext((Object)driver, (Object)context)));
                }
                catch (Exception e) {
                    log.debug((Object)("Error evaluating expression '" + this.expression + "'"), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }
}

