/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.task;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;

public abstract class SQLToolExecuteHandler<OBJECT_TYPE extends DBSObject, SETTINGS extends SQLToolExecuteSettings<OBJECT_TYPE>>
implements DBTTaskHandler {
    public final void executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull Writer logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        SETTINGS settings = this.createToolSettings();
        ((SQLToolExecuteSettings)settings).loadConfiguration(runnableContext, task.getProperties());
        this.executeWithSettings(runnableContext, task, locale, log, logStream, listener, settings);
    }

    private void executeWithSettings(@NotNull DBRRunnableContext runnableContext, DBTTask task, @NotNull Locale locale, @NotNull Log log, Writer logStream, @NotNull DBTTaskExecutionListener listener, SETTINGS settings) throws DBException {
        listener.taskStarted(settings);
        Throwable error = null;
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    this.executeTool(monitor, task, settings, log, logStream);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {
            log.debug((Object)"SQL tools canceled");
        }
        if (error != null) {
            log.error((Object)error);
        }
        listener.taskFinished(settings, error);
    }

    private void executeTool(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, Log log, Writer logStream) throws DBException {
        ArrayList<String> queries = new ArrayList<String>();
        List objectList = ((SQLToolExecuteSettings)settings).getObjectList();
        for (DBSObject object : objectList) {
            Throwable throwable = null;
            Object var11_12 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)"Generate tool queries");){
                this.generateObjectQueries(session, settings, queries, object);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @NotNull
    protected abstract SETTINGS createToolSettings();

    protected abstract void generateObjectQueries(DBCSession var1, SETTINGS var2, List<String> var3, OBJECT_TYPE var4) throws DBCException;
}

