/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;

public abstract class DataTransferHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        ArrayList<IDataTransferProducer> producers = new ArrayList<IDataTransferProducer>();
        ArrayList<IDataTransferConsumer> consumers = new ArrayList<IDataTransferConsumer>();
        for (Object object : ss) {
            IDataTransferNode node = this.adaptTransferNode(object);
            if (node instanceof IDataTransferProducer) {
                producers.add((IDataTransferProducer)node);
                continue;
            }
            if (!(node instanceof IDataTransferConsumer)) continue;
            consumers.add((IDataTransferConsumer)node);
        }
        if (!producers.isEmpty() || !consumers.isEmpty()) {
            try {
                DataTransferWizard.openWizard(workbenchWindow, producers, consumers);
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Data transfer error", "Error opening data transfer wizard", (Throwable)e);
            }
        }
        return null;
    }

    protected abstract IDataTransferNode adaptTransferNode(Object var1);
}

