/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class StreamProducerPageSettings
extends ActiveWizardPage<DataTransferWizard> {
    private PropertyTreeViewer propsEditor;
    private PropertySourceCustom propertySource;
    private Table filesTable;

    public StreamProducerPageSettings() {
        super(DTMessages.data_transfer_wizard_page_input_files_name);
        this.setTitle(DTMessages.data_transfer_wizard_page_input_files_title);
        this.setDescription(DTMessages.data_transfer_wizard_page_input_files_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        SashForm settingsDivider = new SashForm(parent, 512);
        settingsDivider.setLayoutData((Object)new GridData(1808));
        Group inputFilesGroup = UIUtils.createControlGroup((Composite)settingsDivider, (String)DTMessages.data_transfer_wizard_settings_group_input_files, (int)1, (int)1808, (int)0);
        this.filesTable = new Table((Composite)inputFilesGroup, 67588);
        this.filesTable.setLayoutData((Object)new GridData(1808));
        this.filesTable.setHeaderVisible(true);
        this.filesTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source);
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        this.filesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StreamProducerPageSettings.this.filesTable.getSelectionIndex() < 0) {
                    return;
                }
                TableItem item = StreamProducerPageSettings.this.filesTable.getItem(StreamProducerPageSettings.this.filesTable.getSelectionIndex());
                DataTransferPipe pipe = (DataTransferPipe)item.getData();
                if (StreamProducerPageSettings.this.chooseSourceFile(pipe)) {
                    StreamProducerPageSettings.this.updateItemData(item, pipe);
                    StreamProducerPageSettings.this.updatePageCompletion();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.filesTable, (boolean)true));
        Group exporterSettings = UIUtils.createControlGroup((Composite)settingsDivider, (String)DTMessages.data_transfer_wizard_settings_group_importer, (int)1, (int)1808, (int)0);
        this.propsEditor = new PropertyTreeViewer((Composite)exporterSettings, 2048);
        settingsDivider.setWeights(new int[]{400, 600});
        this.setControl((Control)settingsDivider);
        this.updatePageCompletion();
    }

    private boolean chooseSourceFile(DataTransferPipe pipe) {
        ArrayList<String> extensions = new ArrayList<String>();
        String extensionProp = CommonUtils.toString((Object)this.propertySource.getPropertyValue(null, (Object)"extension"));
        String[] stringArray = extensionProp.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensions.add("*." + ext);
            ++n2;
        }
        extensions.add("*");
        File file = DialogUtils.openFile((Shell)this.getShell(), (String[])extensions.toArray(new String[extensions.size()]));
        if (file != null) {
            pipe.setProducer((IDataTransferProducer)new StreamTransferProducer(file));
            this.updatePageCompletion();
            return true;
        }
        return false;
    }

    private void updateItemData(TableItem item, DataTransferPipe pipe) {
        if (pipe.getProducer() == null || pipe.getProducer().getObjectName() == null) {
            item.setImage(0, null);
            item.setText(0, "<none>");
        } else {
            item.setImage(0, DBeaverIcons.getImage((DBPImage)this.getProducerProcessor().getIcon()));
            item.setText(0, pipe.getProducer().getObjectName());
        }
        if (pipe.getConsumer() == null || pipe.getConsumer().getDatabaseObject() == null) {
            item.setImage(1, null);
            item.setText(1, "<none>");
        } else {
            item.setImage(1, DBeaverIcons.getImage((DBPImage)((DataTransferWizard)this.getWizard()).getSettings().getConsumer().getIcon()));
            item.setText(1, DBUtils.getObjectFullName((DBPNamedObject)pipe.getConsumer().getDatabaseObject(), (DBPEvaluationContext)DBPEvaluationContext.DML));
        }
    }

    public void activatePage() {
        DataTransferProcessorDescriptor processor = this.getProducerProcessor();
        DBPPropertyDescriptor[] properties = processor == null ? new DBPPropertyDescriptor[]{} : processor.getProperties();
        this.propertySource = new PropertySourceCustom(properties, ((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        this.filesTable.removeAll();
        for (DataTransferPipe pipe : settings.getDataPipes()) {
            TableItem item = new TableItem(this.filesTable, 0);
            item.setData((Object)pipe);
            this.updateItemData(item, pipe);
        }
        this.updatePageCompletion();
    }

    private DataTransferProcessorDescriptor getProducerProcessor() {
        return ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
    }

    public void deactivatePage() {
        ((DataTransferWizard)this.getWizard()).getSettings().setProcessorProperties(this.propertySource.getPropertiesWithDefaults());
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            if (pipe.getConsumer() != null && pipe.getConsumer().getObjectName() != null && pipe.getProducer() != null && pipe.getProducer().getObjectName() != null) continue;
            return false;
        }
        return true;
    }
}

